/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic.spi;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.generic.internal.util.ContainerIdentity;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.util.log.LoggedObject;

public abstract class AbstractGenericHintFactory<T>
extends LoggedObject {
    private Map<RegistrationKey, Class<? extends T>> mappings = new HashMap<RegistrationKey, Class<? extends T>>();

    protected AbstractGenericHintFactory() {
    }

    protected boolean hasMapping(RegistrationKey key) {
        return this.getMappings().containsKey(key);
    }

    protected Class<? extends T> getMapping(RegistrationKey key) {
        return this.getMappings().get(key);
    }

    protected Map<RegistrationKey, Class<? extends T>> getMappings() {
        return this.mappings;
    }

    protected void registerImplementation(RegistrationKey key, Class<? extends T> implementationClass) {
        this.getMappings().put(key, implementationClass);
    }

    protected T createImplementation(RegistrationKey key, GenericParameters parameters, String implementationConceptName) {
        T implementation;
        if (!this.getMappings().containsKey(key)) {
            String message = "Cannot create " + implementationConceptName + ". There's no registered " + implementationConceptName + " for the parameters (" + key.toString(implementationConceptName) + "). ";
            List<String> hints = this.getHints(key.getContainerIdentity());
            if (hints.isEmpty()) {
                message = message + "Actually there are no valid types registered for this " + implementationConceptName + ". Maybe you've made a mistake spelling it?";
            } else {
                message = message + "Valid types for this " + implementationConceptName + " are: ";
                for (String hint : hints) {
                    message = message + "\n  - " + hint;
                }
            }
            throw new ContainerException(message);
        }
        Class<T> implementationClass = this.getMappings().get(key);
        try {
            Constructor<T> constructor = this.getConstructor(implementationClass, key.getHint(), parameters);
            implementation = this.createInstance(constructor, key.getHint(), parameters);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create " + implementationConceptName + " with implementation " + implementationClass + " for the parameters (" + key.toString(implementationConceptName) + ").", (Throwable)e);
        }
        return implementation;
    }

    protected abstract Constructor<? extends T> getConstructor(Class<? extends T> var1, String var2, GenericParameters var3) throws NoSuchMethodException;

    protected abstract T createInstance(Constructor<? extends T> var1, String var2, GenericParameters var3) throws Exception;

    private List<String> getHints(ContainerIdentity containerIdentity) {
        ArrayList<String> hints = new ArrayList<String>();
        for (Map.Entry<RegistrationKey, Class<T>> mapping : this.getMappings().entrySet()) {
            RegistrationKey key = mapping.getKey();
            if (!key.getContainerIdentity().equals(containerIdentity)) continue;
            hints.add(key.getHint());
        }
        return hints;
    }

    public static interface GenericParameters {
    }
}

