/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.application;

import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.cargo.module.AbstractDescriptor;
import org.codehaus.cargo.module.Dtd;
import org.codehaus.cargo.module.application.ApplicationXml;
import org.codehaus.cargo.module.application.ApplicationXmlTag;
import org.codehaus.cargo.module.application.ApplicationXmlVersion;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class DefaultApplicationXml
extends AbstractDescriptor
implements ApplicationXml {
    public DefaultApplicationXml(Document theDocument) {
        super(theDocument, new Dtd("http://java.sun.com/dtd/application_1_3.dtd"));
    }

    public final ApplicationXmlVersion getVersion() {
        DocumentType docType = this.getDocument().getDoctype();
        if (docType != null) {
            return ApplicationXmlVersion.valueOf(docType);
        }
        return null;
    }

    public final Element getWebModule(String webUri) {
        if (webUri == null) {
            throw new NullPointerException();
        }
        Iterator moduleElements = this.getElements(ApplicationXmlTag.MODULE);
        while (moduleElements.hasNext()) {
            Element webElement;
            Element moduleElement = (Element)moduleElements.next();
            Iterator webElements = this.getNestedElements(moduleElement, ApplicationXmlTag.WEB);
            if (!webElements.hasNext() || !webUri.equals(this.getNestedText(webElement = (Element)webElements.next(), ApplicationXmlTag.WEB_URI))) continue;
            return webElement;
        }
        return null;
    }

    public final String getWebModuleContextRoot(String webUri) {
        Element webModuleElement = this.getWebModule(webUri);
        if (webModuleElement == null) {
            throw new IllegalArgumentException("Web module [" + webUri + "] is not defined");
        }
        return this.getNestedText(webModuleElement, ApplicationXmlTag.CONTEXT_ROOT);
    }

    public final Iterator getWebModuleUris() {
        ArrayList<String> webUris = new ArrayList<String>();
        Iterator moduleElements = this.getElements(ApplicationXmlTag.MODULE);
        while (moduleElements.hasNext()) {
            Element webElement;
            String webUri;
            Element moduleElement = (Element)moduleElements.next();
            Iterator webElements = this.getNestedElements(moduleElement, ApplicationXmlTag.WEB);
            if (!webElements.hasNext() || (webUri = this.getNestedText(webElement = (Element)webElements.next(), ApplicationXmlTag.WEB_URI)) == null) continue;
            webUris.add(webUri);
        }
        return webUris.iterator();
    }

    public final Iterator getEjbModules() {
        ArrayList<String> modules = new ArrayList<String>();
        Iterator moduleElements = this.getElements(ApplicationXmlTag.MODULE);
        while (moduleElements.hasNext()) {
            Element moduleElement = (Element)moduleElements.next();
            String ejb = this.getNestedText(moduleElement, ApplicationXmlTag.EJB);
            if (ejb == null) continue;
            modules.add(ejb);
        }
        return modules.iterator();
    }

    public final Iterator getElements(ApplicationXmlTag tag) {
        return super.getElements(tag);
    }

    public void addWebModule(String theUri, String context) {
        Element moduleElement = this.getDocument().createElement(ApplicationXmlTag.MODULE.getTagName());
        Element webElement = this.getDocument().createElement(ApplicationXmlTag.WEB.getTagName());
        webElement.appendChild(this.createNestedText(ApplicationXmlTag.WEB_URI, theUri));
        webElement.appendChild(this.createNestedText(ApplicationXmlTag.CONTEXT_ROOT, context));
        moduleElement.appendChild(webElement);
        this.addElement(ApplicationXmlTag.MODULE, moduleElement, this.getRootElement());
    }

    public void addEjbModule(String theName) {
        Element moduleElement = this.getDocument().createElement(ApplicationXmlTag.MODULE.getTagName());
        moduleElement.appendChild(this.createNestedText(ApplicationXmlTag.EJB, theName));
        this.addElement(ApplicationXmlTag.MODULE, moduleElement, this.getRootElement());
    }
}

