/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.ejb.orion;

import java.util.Iterator;
import org.codehaus.cargo.module.AbstractDescriptor;
import org.codehaus.cargo.module.AbstractDescriptorTag;
import org.codehaus.cargo.module.Dtd;
import org.codehaus.cargo.module.ejb.EjbDef;
import org.codehaus.cargo.module.ejb.VendorEjbDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OrionEjbJarXml
extends AbstractDescriptor
implements VendorEjbDescriptor {
    public OrionEjbJarXml(Document document) {
        super(document, new Dtd("http://www.oracle.com/technology/ias/dtds/orion-ejb-jar-9_04.dtd"));
    }

    public String getFileName() {
        return "orion-ejb-jar.xml";
    }

    public String getJndiName(EjbDef ejb) {
        String jndiName = null;
        Element ejbElement = this.getEjb(ejb.getName());
        if (ejbElement != null) {
            jndiName = ejbElement.getAttribute("location");
        }
        return jndiName;
    }

    private Element getEjb(String ejbName) {
        Element ejbElement = this.getSessionEjb(ejbName);
        if (ejbElement == null) {
            ejbElement = this.getEntityEjb(ejbName);
        }
        return ejbElement;
    }

    private Element getSessionEjb(String ejbName) {
        Element ejbElement = null;
        Iterator names = this.getElements(new AbstractDescriptorTag("session-deployment", true));
        while (names.hasNext()) {
            Element deploymentElement = (Element)names.next();
            String name = deploymentElement.getAttribute("name");
            if (!name.equals(ejbName)) continue;
            ejbElement = deploymentElement;
            break;
        }
        return ejbElement;
    }

    private Element getEntityEjb(String ejbName) {
        Element ejbElement = null;
        Iterator names = this.getElements(new AbstractDescriptorTag("entity-deployment", true));
        while (names.hasNext()) {
            Element deploymentElement = (Element)names.next();
            String name = deploymentElement.getAttribute("name");
            if (!name.equals(ejbName)) continue;
            ejbElement = deploymentElement;
            break;
        }
        return ejbElement;
    }
}

