/* 
 * ========================================================================
 * 
 * Copyright 2004 Vincent Massol.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * ========================================================================
 */
package org.codehaus.cargo.module.webapp.resin;

import org.codehaus.cargo.module.DescriptorTag;


/**
 * Represents the various top-level tags in a Resin context web deployment 
 * descriptor as a typesafe enumeration.
 * 
 * @version $Id $
 */
public final class ResinWebXmlTag extends DescriptorTag
{
    /**
     * Attribute name 'path'.
     */
    public static final ResinWebXmlTag SYSTEM_PROPERTY =
        new ResinWebXmlTag("system-property", true);
    
    /**
     * Elements of resource-ref.
     */
    public static final ResinWebXmlTag RESOURCE_REFERENCE =
        new ResinWebXmlTag("resource-ref", true);

    /**
     * Elements of session-config.
     */
    public static final ResinWebXmlTag SESSION_CONFIG =
        new ResinWebXmlTag("session-config", true);

    /**
     * Elements of directory-servlet.
     */
    public static final ResinWebXmlTag DIRECTORY_SERVLET =
        new ResinWebXmlTag("directory-servlet", true);

    /**
     * Elements of jndi-link.
     */
    public static final ResinWebXmlTag JNDI_LINK =
        new ResinWebXmlTag("jndi-link", true);
    
    /**
     * Constructor.
     * 
     * @param tagName The tag name of the element
     * @param isMultipleAllowed Whether the element may occur multiple times in
     *         the descriptor
     */
    protected ResinWebXmlTag(String tagName, boolean isMultipleAllowed)
    {
        super(tagName, isMultipleAllowed);
    }

    /**
     * Constructor.
     * 
     * @param tagName The tag name of the element
     */
    protected ResinWebXmlTag(String tagName)
    {
        this(tagName, true);
    }
}
