/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.DescriptorIo;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.J2eeDescriptor;
import org.codehaus.cargo.module.XmlEntityResolver;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.EntityResolver;

public abstract class AbstractDescriptorIo
implements DescriptorIo {
    private DescriptorType factory;

    protected AbstractDescriptorIo(DescriptorType descriptorType) {
        this.factory = descriptorType;
    }

    public SAXBuilder createDocumentBuilder() {
        return this.createDocumentBuilder(null);
    }

    public SAXBuilder createDocumentBuilder(EntityResolver theEntityResolver) {
        SAXBuilder factory = new SAXBuilder();
        factory.setValidation(false);
        factory.setFactory(this.factory.getJDOMFactory());
        EntityResolver resolver = theEntityResolver;
        if (resolver == null) {
            resolver = this.getEntityResolver();
        }
        if (resolver != null) {
            factory.setEntityResolver(resolver);
        }
        return factory;
    }

    protected EntityResolver getEntityResolver() {
        return null;
    }

    public Document parseXml(InputStream input) throws JDOMException, IOException {
        return this.parseXml(input, new XmlEntityResolver());
    }

    public Document parseXml(InputStream input, EntityResolver resolver) throws JDOMException, IOException {
        SAXBuilder builder = this.createDocumentBuilder(resolver);
        return builder.build(input);
    }

    public static void writeDescriptor(Descriptor descriptor, File file) throws IOException {
        AbstractDescriptorIo.writeDescriptor(descriptor, file, null, false);
    }

    public static void writeDescriptor(Descriptor descriptor, File file, String encoding) throws IOException {
        AbstractDescriptorIo.writeDescriptor(descriptor, file, encoding, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDescriptor(Descriptor descriptor, File file, String encoding, boolean isIndent) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            AbstractDescriptorIo.writeDescriptor(descriptor, out, encoding, isIndent);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static void writeDescriptor(Descriptor descriptor, OutputStream out, String encoding, boolean isIndent) throws IOException {
        XMLOutputter serializer = new XMLOutputter();
        Format format = Format.getPrettyFormat();
        serializer.setFormat(format);
        serializer.output((Document)descriptor, out);
    }

    public static File[] writeAll(J2eeDescriptor descriptor, String dir) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        File webXmlFile = new File(dir, "web.xml");
        AbstractDescriptorIo.writeDescriptor((Descriptor)descriptor, webXmlFile, null, true);
        files.add(webXmlFile);
        Iterator vendorDescriptors = descriptor.getVendorDescriptors();
        while (vendorDescriptors.hasNext()) {
            Descriptor descr = (Descriptor)vendorDescriptors.next();
            File file = new File(dir, descr.getFileName());
            AbstractDescriptorIo.writeDescriptor(descr, file, null, true);
            files.add(file);
        }
        return files.toArray(new File[files.size()]);
    }
}

