/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.codehaus.cargo.module.JarArchive;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.Logger;

public class DefaultJarArchive
implements JarArchive {
    private byte[] content;
    private String sourceFile;
    private FileHandler fileHandler = new DefaultFileHandler();

    public DefaultJarArchive(String file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.sourceFile = file;
        this.content = null;
    }

    public DefaultJarArchive(InputStream inputStream) throws IOException {
        this.sourceFile = null;
        this.content = this.streamToByteArray(inputStream);
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    @Override
    public boolean containsClass(String className) throws IOException {
        String resourceName = className.replace('.', '/') + ".class";
        return this.getResource(resourceName) != null;
    }

    @Override
    public String findResource(String name) throws IOException {
        String result = null;
        for (String entryPath : this.getResources("")) {
            String entryName = entryPath;
            int lastSlashIndex = entryName.lastIndexOf(47);
            if (lastSlashIndex >= 0) {
                entryName = entryName.substring(lastSlashIndex + 1);
            }
            if (!entryName.equals(name)) continue;
            result = entryPath;
            break;
        }
        return result;
    }

    @Override
    public InputStream getResource(String path) throws IOException {
        try (JarInputStream in = this.getContentAsStream();){
            ZipEntry zipEntry;
            while ((zipEntry = in.getNextEntry()) != null) {
                int bytesRead;
                if (!path.equals(zipEntry.getName())) continue;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] bytes = new byte[2048];
                while ((bytesRead = in.read(bytes)) != -1) {
                    buffer.write(bytes, 0, bytesRead);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer.toByteArray());
                return byteArrayInputStream;
            }
        }
        return null;
    }

    @Override
    public List<String> getResources(String path) throws IOException {
        String normalizedPath = path;
        if (!path.endsWith("/") && !path.isEmpty()) {
            normalizedPath = path + "/";
        }
        ArrayList<String> resources = new ArrayList<String>();
        try (JarInputStream in = this.getContentAsStream();){
            ZipEntry zipEntry;
            while ((zipEntry = in.getNextEntry()) != null) {
                if (!zipEntry.getName().startsWith(normalizedPath) || zipEntry.getName().equals(normalizedPath)) continue;
                resources.add(zipEntry.getName());
            }
        }
        return resources;
    }

    protected final JarInputStream getContentAsStream() throws IOException {
        if (this.content != null) {
            return new JarInputStream(new ByteArrayInputStream(this.content));
        }
        return new JarInputStream(this.getFileHandler().getInputStream(this.sourceFile));
    }

    @Override
    public void expandToPath(String path) throws IOException {
        try (JarInputStream inputStream = this.getContentAsStream();){
            ZipEntry entry;
            byte[] buffer = new byte[40960];
            while ((entry = inputStream.getNextEntry()) != null) {
                String outFile = this.getFileHandler().append(path, DefaultFileHandler.sanitizeFilename((String)entry.getName(), (Logger)this.getFileHandler().getLogger()));
                if (entry.isDirectory()) {
                    this.getFileHandler().mkdirs(outFile);
                    continue;
                }
                String parent = this.getFileHandler().getParent(outFile);
                if (!this.getFileHandler().exists(parent)) {
                    this.getFileHandler().mkdirs(parent);
                }
                if (!this.getFileHandler().exists(outFile)) {
                    this.getFileHandler().createFile(outFile);
                }
                OutputStream out = this.getFileHandler().getOutputStream(outFile);
                try {
                    int read;
                    while ((read = inputStream.read(buffer)) > 0) {
                        out.write(buffer, 0, read);
                    }
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] streamToByteArray(InputStream inputStream) throws IOException {
        try {
            int bytesRead;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[40960];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

