/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.application;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.cargo.module.DefaultJarArchive;
import org.codehaus.cargo.module.application.ApplicationXml;
import org.codehaus.cargo.module.application.ApplicationXmlIo;
import org.codehaus.cargo.module.application.EarArchive;
import org.codehaus.cargo.module.ejb.DefaultEjbArchive;
import org.codehaus.cargo.module.ejb.EjbArchive;
import org.codehaus.cargo.module.webapp.DefaultWarArchive;
import org.codehaus.cargo.module.webapp.WarArchive;
import org.jdom2.JDOMException;

public class DefaultEarArchive
extends DefaultJarArchive
implements EarArchive {
    private ApplicationXml applicationXml;

    public DefaultEarArchive(String file) {
        super(file);
    }

    public DefaultEarArchive(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    @Override
    public ApplicationXml getApplicationXml() throws IOException, JDOMException {
        if (this.applicationXml == null) {
            try (InputStream in = this.getResource("META-INF/application.xml");){
                this.applicationXml = ApplicationXmlIo.parseApplicationXml(in, null);
            }
        }
        return this.applicationXml;
    }

    @Override
    public WarArchive getWebModule(String uri) throws IOException {
        try (InputStream war = this.getResource(uri);){
            if (war != null) {
                DefaultWarArchive defaultWarArchive = new DefaultWarArchive(war);
                return defaultWarArchive;
            }
        }
        return null;
    }

    @Override
    public EjbArchive getEjbModule(String uri) throws IOException {
        try (InputStream ejb = this.getResource(uri);){
            if (ejb != null) {
                DefaultEjbArchive defaultEjbArchive = new DefaultEjbArchive(ejb);
                return defaultEjbArchive;
            }
        }
        return null;
    }
}

