/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.merge;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import org.codehaus.cargo.module.DescriptorIo;
import org.codehaus.cargo.module.merge.MergeException;
import org.codehaus.cargo.module.merge.MergeProcessor;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentStreamAdapter
implements MergeProcessor {
    private MergeProcessor next;
    private DescriptorIo descriptorIo;

    public DocumentStreamAdapter(MergeProcessor next) {
        this.next = next;
    }

    @Override
    public void addMergeItem(Object mergeItem) throws MergeException {
        if (mergeItem instanceof InputStream) {
            try {
                this.next.addMergeItem(this.getDocument((InputStream)mergeItem));
            }
            catch (Exception e) {
                throw new MergeException("Exception creating document", e);
            }
        } else {
            throw new MergeException("DocumentMerger can only merge InputStreams");
        }
    }

    @Override
    public Object performMerge() throws MergeException {
        try {
            Document doc = (Document)this.next.performMerge();
            if (doc == null) {
                return null;
            }
            XMLOutputter serializer = new XMLOutputter();
            Format format = Format.getPrettyFormat();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            serializer.setFormat(format);
            serializer.output(doc, (OutputStream)out);
            byte[] data = out.toByteArray();
            return new ByteArrayInputStream(data);
        }
        catch (Exception e) {
            throw new MergeException("Error whilst merging documents", e);
        }
    }

    protected Document getDocument(InputStream theInput) throws IOException, JDOMException {
        if (this.descriptorIo == null) {
            SAXBuilder builder = new SAXBuilder();
            builder.setValidation(false);
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String thePublicId, String theSystemId) throws SAXException {
                    return new InputSource(new StringReader(""));
                }
            });
            return builder.build(theInput);
        }
        return this.descriptorIo.createDocumentBuilder().build(theInput);
    }

    public DescriptorIo getDescriptorIo() {
        return this.descriptorIo;
    }

    public void setDescriptorIo(DescriptorIo descriptorIo) {
        this.descriptorIo = descriptorIo;
    }
}

