/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.cargo.module.AbstractDescriptorIo;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXml22Type;
import org.codehaus.cargo.module.webapp.WebXml23Type;
import org.codehaus.cargo.module.webapp.WebXml24Type;
import org.codehaus.cargo.module.webapp.WebXml25Type;
import org.codehaus.cargo.module.webapp.WebXml30Type;
import org.codehaus.cargo.module.webapp.WebXmlTypeAwareParser;
import org.codehaus.cargo.module.webapp.WebXmlVersion;
import org.codehaus.cargo.util.CargoException;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class WebXmlIo
extends AbstractDescriptorIo {
    public WebXmlIo(DescriptorType type) {
        super(type);
    }

    protected EntityResolver getEntityResolver() {
        return new WebXmlEntityResolver();
    }

    public static WebXml newWebXml(WebXmlVersion theVersion) {
        Element root = new Element("web-app");
        Document document = null;
        if (theVersion.equals(WebXmlVersion.V2_2)) {
            document = new WebXml22Type().document(root);
            document.setDocType(new DocType("web-app", "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd"));
        } else if (theVersion.equals(WebXmlVersion.V2_3)) {
            document = new WebXml23Type().document(root);
            document.setDocType(new DocType("web-app", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "http://java.sun.com/dtd/web-app_2_3.dtd"));
        } else if (theVersion.equals(WebXmlVersion.V2_4)) {
            document = new WebXml24Type().document(root);
            document.setDocType(new DocType("web-app", "http://java.sun.com/xml/ns/j2ee"));
        } else if (theVersion.equals(WebXmlVersion.V2_5)) {
            document = new WebXml25Type().document(root);
            document.setDocType(new DocType("web-app", "http://java.sun.com/xml/ns/j2ee"));
        } else if (theVersion.equals(WebXmlVersion.V3_0)) {
            document = new WebXml30Type().document(root);
            document.setDocType(new DocType("web-app", "http://java.sun.com/xml/ns/j2ee"));
        } else {
            document = new WebXml25Type().document(root);
            document.setDocType(new DocType("web-app", "http://java.sun.com/xml/ns/j2ee"));
        }
        return (WebXml)document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebXml parseWebXmlFromFile(File theFile, EntityResolver theEntityResolver) throws IOException, JDOMException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(theFile);
            WebXml webXml = WebXmlIo.parseWebXml(in, theEntityResolver);
            return webXml;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static WebXml parseWebXml(InputStream theInput, EntityResolver theEntityResolver) throws IOException, JDOMException {
        WebXmlTypeAwareParser handler = new WebXmlTypeAwareParser(theInput, theEntityResolver);
        WebXml result = handler.parse();
        if (result == null) {
            throw new CargoException("Parsing the web.xml returned null");
        }
        return result;
    }

    private static class WebXmlEntityResolver
    implements EntityResolver {
        private WebXmlEntityResolver() {
        }

        public InputSource resolveEntity(String thePublicId, String theSystemId) throws SAXException, IOException {
            WebXmlVersion version = WebXmlVersion.valueOf(thePublicId);
            if (version != null) {
                String fileName = version.getSystemId().substring(version.getSystemId().lastIndexOf(47));
                InputStream in = this.getClass().getResourceAsStream("/org/codehaus/cargo/module/internal/resource" + fileName);
                if (in != null) {
                    return new InputSource(in);
                }
            }
            return null;
        }
    }
}

