/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.codehaus.cargo.module.DescriptorElement;
import org.codehaus.cargo.module.DescriptorIo;
import org.codehaus.cargo.module.DescriptorTag;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.Grammar;
import org.codehaus.cargo.util.CargoException;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.jdom.Namespace;

public class AbstractDescriptorType
extends DefaultJDOMFactory
implements JDOMFactory,
DescriptorType {
    private DescriptorType parent;
    private Grammar grammar;
    private List<DescriptorTag> tags;
    private Class descriptorClass;
    private DescriptorIo descriptorIo;

    protected AbstractDescriptorType(DescriptorType parent, Class descriptorClass, Grammar grammar) {
        this.parent = parent;
        this.grammar = grammar;
        this.descriptorClass = descriptorClass;
        this.tags = new ArrayList<DescriptorTag>();
    }

    @Override
    public DescriptorIo getDescriptorIo() {
        return this.descriptorIo;
    }

    protected void setDescriptorIo(DescriptorIo descriptorIo) {
        this.descriptorIo = descriptorIo;
    }

    @Override
    public Grammar getGrammar() {
        return this.grammar;
    }

    @Override
    public void addTag(DescriptorTag tag) {
        this.tags.add(tag);
    }

    @Override
    public DescriptorTag getTagByName(String name) {
        for (DescriptorTag tag : this.tags) {
            if (!tag.getTagName().equals(name)) continue;
            return tag;
        }
        return this.parent != null ? this.parent.getTagByName(name) : null;
    }

    @Override
    public Collection<DescriptorTag> getAllTags() {
        ArrayList<DescriptorTag> items = new ArrayList<DescriptorTag>(this.tags);
        if (this.parent != null) {
            items.addAll(this.parent.getAllTags());
        }
        return items;
    }

    public Element element(String name) {
        DescriptorTag tag = this.getTagByName(name);
        if (tag != null) {
            try {
                return tag.create();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.element(name);
    }

    public Element element(String name, Namespace namespace) {
        DescriptorTag tag = this.getTagByName(name);
        if (tag != null) {
            try {
                DescriptorElement element = tag.create();
                if (element.getNamespace() == null && namespace != null) {
                    element.setNamespace(namespace);
                }
                return element;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.element(name, namespace);
    }

    public Document document(Element rootElement) {
        if (this.descriptorClass != null) {
            try {
                Constructor constructor = this.descriptorClass.getConstructor(Element.class, DescriptorType.class);
                Document doc = (Document)constructor.newInstance(rootElement, this);
                return doc;
            }
            catch (Exception ex) {
                throw new CargoException("Error constructing document type", (Throwable)ex);
            }
        }
        return new Document(rootElement);
    }

    @Override
    public JDOMFactory getJDOMFactory() {
        return this;
    }
}

