/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp.merge;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.codehaus.cargo.module.JarArchive;
import org.codehaus.cargo.module.merge.MergeException;
import org.codehaus.cargo.module.merge.MergeProcessor;

public class ArchiveResourceMerger {
    private MergeProcessor next;
    private String resource;

    public ArchiveResourceMerger(String resource, MergeProcessor next) {
        this.next = next;
        this.resource = resource;
    }

    public void addMergeItem(Object mergeItem) throws MergeException {
        try {
            JarArchive jar = (JarArchive)mergeItem;
            InputStream is = jar.getResource(this.resource);
            if (is != null) {
                this.next.addMergeItem(is);
            }
        }
        catch (Exception ex) {
            throw new MergeException("Problem when fetching merge item from War Archive", ex);
        }
    }

    public void execute(File assembleDir) throws MergeException {
        try (InputStream is = (InputStream)this.next.performMerge();){
            if (is == null) {
                return;
            }
            File outputFile = new File(assembleDir.getAbsolutePath() + File.separator + this.resource);
            outputFile.getParentFile().mkdir();
            try (FileOutputStream fos = new FileOutputStream(outputFile);){
                int count;
                byte[] buffer = new byte[1024];
                while ((count = is.read(buffer)) > 0) {
                    fos.write(buffer, 0, count);
                }
            }
        }
        catch (Exception e) {
            throw new MergeException("Problem executing merge", e);
        }
    }
}

