/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.application;

import org.jdom.DocType;

public final class ApplicationXmlVersion
implements Comparable<ApplicationXmlVersion> {
    public static final ApplicationXmlVersion V1_2 = new ApplicationXmlVersion("1.2", "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN", "http://java.sun.com/j2ee/dtds/application_1_2.dtd");
    public static final ApplicationXmlVersion V1_3 = new ApplicationXmlVersion("1.3", "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "http://java.sun.com/dtd/application_1_3.dtd");
    private String systemId;
    private String version;
    private String publicId;

    private ApplicationXmlVersion(String theVersion, String thePublicId, String theSystemId) {
        this.version = theVersion;
        this.publicId = thePublicId;
        this.systemId = theSystemId;
    }

    @Override
    public int compareTo(ApplicationXmlVersion other) {
        double thisVersion = this.version == null ? 0.0 : Double.parseDouble(this.version);
        double thatVersion = other == null || other.version == null ? 0.0 : Double.parseDouble(other.version);
        return Double.compare(thisVersion, thatVersion);
    }

    public String getVersion() {
        return this.version;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String toString() {
        return this.getVersion();
    }

    public static ApplicationXmlVersion valueOf(DocType theDocType) throws NullPointerException {
        return ApplicationXmlVersion.valueOf(theDocType.getPublicID());
    }

    public static ApplicationXmlVersion valueOf(String thePublicId) {
        ApplicationXmlVersion version = null;
        if (V1_2.getPublicId().equals(thePublicId)) {
            version = V1_2;
        } else if (V1_3.getPublicId().equals(thePublicId)) {
            version = V1_3;
        }
        return version;
    }
}

