/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.merge.tagstrategy;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.DescriptorElement;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.merge.tagstrategy.MergeStrategy;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.xpath.XPath;

public class NodeMergeStrategy
implements MergeStrategy {
    private Element template;

    public NodeMergeStrategy(DescriptorType type, Element template) {
        if (template == null) {
            throw new IllegalArgumentException("Template must not be null");
        }
        this.template = template;
    }

    public NodeMergeStrategy(DescriptorType type, InputStream stream) throws IOException, JDOMException {
        this.template = type.getDescriptorIo().parseXml(stream).getRootElement();
    }

    @Override
    public int inBoth(Descriptor target, DescriptorElement left, DescriptorElement right) {
        int idx = target.getDocument().getRootElement().getContent().indexOf((Object)left);
        target.getDocument().getRootElement().removeContent((Content)left);
        Element newElement = (Element)this.template.clone();
        this.applyValues((Content)newElement, left, right);
        target.getRootElement().addContent(idx, (Content)newElement);
        return 1;
    }

    @Override
    public int inLeft(Descriptor target, DescriptorElement left) {
        return 0;
    }

    @Override
    public int inRight(Descriptor target, DescriptorElement right) {
        target.addElement(right.getTag(), right, target.getRootElement());
        return 1;
    }

    private void applyValues(Content content, DescriptorElement left, DescriptorElement right) {
        if (content instanceof Element) {
            Element element = (Element)content;
            List childNodes = element.getContent();
            for (Content n : childNodes) {
                this.applyValues(n, left, right);
            }
        } else if (content instanceof Text) {
            Pattern pat = Pattern.compile("\\$(left:|right:)[^ ,\\t]*");
            Text element = (Text)content;
            Matcher m = pat.matcher(element.getText());
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String repl = this.replaceValue(m.group(), left, right).replaceAll("\\$", "\\\\\\$");
                m.appendReplacement(sb, repl);
            }
            m.appendTail(sb);
            element.setText(sb.toString());
        }
    }

    private String replaceValue(String string, DescriptorElement left, DescriptorElement right) {
        DescriptorElement element;
        String xPath;
        String result = "";
        if (string.startsWith("$left:")) {
            xPath = string.substring(6);
            element = left;
        } else if (string.startsWith("$right:")) {
            xPath = string.substring(7);
            element = right;
        } else {
            return "";
        }
        try {
            Element nestedText;
            String nsPrefix = null;
            if (!(element.getNamespaceURI().isEmpty() || !(nsPrefix = element.getNamespacePrefix()).isEmpty() && xPath.startsWith(nsPrefix))) {
                if (nsPrefix.isEmpty()) {
                    nsPrefix = "cargo-xs";
                }
                xPath = nsPrefix + ":" + xPath;
            }
            XPath xp = XPath.newInstance((String)xPath);
            if (nsPrefix != null) {
                xp.addNamespace(nsPrefix, element.getNamespaceURI());
            }
            if ((nestedText = (Element)xp.selectSingleNode((Object)element)) != null) {
                result = nestedText.getText();
            }
        }
        catch (JDOMException e) {
            result = e.getMessage();
        }
        return result;
    }
}

