/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.codehaus.cargo.module.AbstractDescriptorIo;
import org.codehaus.cargo.module.DefaultJarArchive;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.webapp.WarArchive;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlIo;
import org.codehaus.cargo.module.webapp.jboss.JBossWebXml;
import org.codehaus.cargo.module.webapp.jboss.JBossWebXmlIo;
import org.codehaus.cargo.module.webapp.orion.OrionWebXml;
import org.codehaus.cargo.module.webapp.orion.OrionWebXmlIo;
import org.codehaus.cargo.module.webapp.resin.ResinWebXml;
import org.codehaus.cargo.module.webapp.resin.ResinWebXmlIo;
import org.codehaus.cargo.module.webapp.weblogic.WeblogicXml;
import org.codehaus.cargo.module.webapp.weblogic.WeblogicXmlIo;
import org.codehaus.cargo.module.webapp.websphere.IbmWebBndXmi;
import org.codehaus.cargo.module.webapp.websphere.IbmWebBndXmiIo;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.jdom.JDOMException;

public class DefaultWarArchive
extends DefaultJarArchive
implements WarArchive {
    private WebXml webXml;
    private String file;

    public DefaultWarArchive(String file) {
        super(file);
        this.file = file;
    }

    public DefaultWarArchive(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    @Override
    public WebXml getWebXml() throws IOException, JDOMException {
        if (this.webXml == null) {
            try (InputStream in = this.getResource("WEB-INF/web.xml");){
                this.webXml = in != null ? WebXmlIo.parseWebXml(in, null) : new WebXml();
            }
            catch (Exception ex) {
                throw new CargoException("Error parsing the web.xml file in " + this.file, (Throwable)ex);
            }
            this.addWeblogicDescriptor();
            this.addOracleDescriptor();
            this.addWebsphereDescriptor();
            this.addResinDescriptor();
            this.addJBossDescriptor();
        }
        return this.webXml;
    }

    @Override
    public void store(File warFile) throws IOException, JDOMException {
        JarOutputStream out;
        DefaultFileHandler fileHandler = new DefaultFileHandler();
        try (JarInputStream in = this.getContentAsStream();){
            JarEntry entry;
            out = new JarOutputStream(new FileOutputStream(warFile));
            ArrayList<String> descriptorNames = new ArrayList<String>();
            descriptorNames.add("WEB-INF/" + this.getWebXml().getFileName());
            for (Descriptor vendorDescriptor : this.getWebXml().getVendorDescriptors()) {
                descriptorNames.add("WEB-INF/" + vendorDescriptor.getFileName());
            }
            while ((entry = in.getNextJarEntry()) != null) {
                if (descriptorNames.contains(entry.getName())) continue;
                out.putNextEntry(entry);
                fileHandler.copy((InputStream)in, (OutputStream)out);
            }
        }
        JarEntry webXmlEntry = new JarEntry("WEB-INF/" + this.getWebXml().getFileName());
        out.putNextEntry(webXmlEntry);
        AbstractDescriptorIo.writeDescriptor((Descriptor)this.getWebXml(), out, StandardCharsets.UTF_8, true);
        for (Descriptor descriptor : this.getWebXml().getVendorDescriptors()) {
            JarEntry descriptorEntry = new JarEntry("WEB-INF/" + descriptor.getFileName());
            out.putNextEntry(descriptorEntry);
            AbstractDescriptorIo.writeDescriptor(descriptor, out, StandardCharsets.UTF_8, true);
        }
        out.close();
    }

    @Override
    public boolean containsClass(String className) throws IOException {
        boolean containsClass = false;
        String resourceName = "WEB-INF/classes/" + className.replace('.', '/') + ".class";
        if (this.getResource(resourceName) != null) {
            containsClass = true;
        }
        for (String resource : this.getResources("WEB-INF/lib/")) {
            DefaultJarArchive jar = new DefaultJarArchive(this.getResource(resource));
            if (!jar.containsClass(className)) continue;
            containsClass = true;
        }
        return containsClass;
    }

    private void addWeblogicDescriptor() throws IOException, JDOMException {
        try (InputStream in = this.getResource("WEB-INF/weblogic.xml");){
            WeblogicXml descr;
            if (in != null && (descr = WeblogicXmlIo.parseWeblogicXml(in)) != null) {
                this.webXml.addVendorDescriptor(descr);
            }
        }
    }

    private void addResinDescriptor() throws IOException, JDOMException {
        try (InputStream in = this.getResource("WEB-INF/resin-web.xml");){
            ResinWebXml descr;
            if (in != null && (descr = ResinWebXmlIo.parseResinXml(in)) != null) {
                this.webXml.addVendorDescriptor(descr);
            }
        }
    }

    private void addOracleDescriptor() throws IOException, JDOMException {
        try (InputStream in = this.getResource("WEB-INF/orion-web.xml");){
            OrionWebXml descr;
            if (in != null && (descr = OrionWebXmlIo.parseOrionXml(in)) != null) {
                this.webXml.addVendorDescriptor(descr);
            }
        }
    }

    private void addWebsphereDescriptor() throws IOException, JDOMException {
        try (InputStream in = this.getResource("WEB-INF/ibm-web-bnd.xmi");){
            IbmWebBndXmi descr;
            if (in != null && (descr = IbmWebBndXmiIo.parseIbmWebBndXmi(in)) != null) {
                this.webXml.addVendorDescriptor(descr);
            }
        }
    }

    private void addJBossDescriptor() throws IOException, JDOMException {
        try (InputStream in = this.getResource("WEB-INF/jboss-web.xml");){
            JBossWebXml descr;
            if (in != null && (descr = JBossWebXmlIo.parseJBossWebXml(in)) != null) {
                this.webXml.addVendorDescriptor(descr);
            }
        }
    }
}

