/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp.tomcat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.cargo.module.JarArchive;
import org.codehaus.cargo.module.JarArchiveIo;
import org.codehaus.cargo.module.webapp.tomcat.TomcatContextXml;
import org.codehaus.cargo.module.webapp.tomcat.TomcatContextXmlIo;
import org.jdom.JDOMException;

public class TomcatWarArchive {
    private String warFile;
    private TomcatContextXml tomcatContextXml;

    public TomcatWarArchive(String warFile) throws IOException, JDOMException {
        this.warFile = warFile;
        this.tomcatContextXml = this.parseTomcatContextXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TomcatContextXml parseTomcatContextXml() throws IOException, JDOMException {
        TomcatContextXml context = null;
        try (InputStream in = null;){
            if (new File(this.warFile).isDirectory()) {
                File contextXmlFile = new File(this.warFile, "META-INF/context.xml");
                if (contextXmlFile.exists()) {
                    in = new FileInputStream(contextXmlFile);
                }
            } else {
                JarArchive jarArchive = JarArchiveIo.open(new File(this.warFile));
                in = jarArchive.getResource("META-INF/context.xml");
            }
            if (in != null) {
                context = TomcatContextXmlIo.parseTomcatConfigXml(in);
            }
        }
        return context;
    }

    public TomcatContextXml getTomcatContextXml() {
        return this.tomcatContextXml;
    }
}

