/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.FileHandler;

public class DefaultFileHandler
implements FileHandler {
    private static int uniqueNameCounter = -1;
    private AntUtils antUtils = new AntUtils();
    private FileUtils fileUtils = FileUtils.newFileUtils();

    private AntUtils getAntUtils() {
        return this.antUtils;
    }

    private FileUtils getFileUtils() {
        return this.fileUtils;
    }

    public void copyFile(String source, String target) {
        try {
            this.getFileUtils().copyFile(new File(source).getAbsolutePath(), new File(target).getAbsolutePath());
        }
        catch (IOException e) {
            throw new CargoException("Failed to copy source file [" + source + "] to [" + target + "]", e);
        }
    }

    public void copyFile(String source, String target, boolean overwrite) {
        try {
            this.getFileUtils().copyFile(new File(source).getAbsolutePath(), new File(target).getAbsolutePath(), null, overwrite);
        }
        catch (IOException e) {
            throw new CargoException("Failed to copy source file [" + source + "] to [" + target + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String source, String target, FilterChain filterChain) {
        try {
            this.getFileUtils().copyFile(new File(source).getAbsolutePath(), new File(target).getAbsolutePath());
            FileInputStream fileIS = new FileInputStream(source);
            if (fileIS == null) {
                throw new IOException("File [" + source + "] not found");
            }
            BufferedReader in = null;
            BufferedWriter out = null;
            try {
                String line;
                ChainReaderHelper helper = new ChainReaderHelper();
                helper.setBufferSize(8192);
                helper.setPrimaryReader((Reader)new BufferedReader(new InputStreamReader(fileIS)));
                Vector<FilterChain> filterChains = new Vector<FilterChain>();
                filterChains.add(filterChain);
                helper.setFilterChains(filterChains);
                in = new BufferedReader(helper.getAssembledReader());
                out = new BufferedWriter(new FileWriter(target));
                while ((line = in.readLine()) != null) {
                    if (line.length() == 0) {
                        out.newLine();
                        continue;
                    }
                    out.write(line);
                    out.newLine();
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            throw new CargoException("Failed to copy source file [" + source + "] to [" + target + "] with FilterChain", e);
        }
    }

    public void copyDirectory(String source, String target) {
        this.copyDirectory(source, target, new ArrayList());
    }

    public void copyDirectory(String source, String target, List excludes) {
        try {
            Copy copyTask = (Copy)this.getAntUtils().createAntTask("copy");
            copyTask.setTodir(new File(target));
            FileSet fileSet = new FileSet();
            fileSet.setDir(new File(source));
            for (String excludeName : excludes) {
                fileSet.createExclude().setName(excludeName);
            }
            copyTask.addFileset(fileSet);
            copyTask.setFailOnError(true);
            copyTask.setIncludeEmptyDirs(true);
            copyTask.setOverwrite(true);
            copyTask.execute();
        }
        catch (BuildException e) {
            throw new CargoException("Failed to copy source directory [" + source + "] to [" + target + "]", e);
        }
    }

    public String createDirectory(String parentDir, String name) {
        File dir = new File(parentDir, name);
        dir.mkdirs();
        if (!dir.isDirectory() || !dir.exists()) {
            throw new CargoException("Couldn't create directory " + dir.getAbsolutePath());
        }
        return dir.getPath();
    }

    public void copy(InputStream in, OutputStream out, int bufSize) {
        try {
            int length;
            byte[] buf = new byte[bufSize];
            while ((length = in.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
        }
        catch (IOException e) {
            throw new CargoException("Failed to copy input stream [" + in.toString() + "] to output stream [" + out.toString() + "]", e);
        }
    }

    public void copy(InputStream in, OutputStream out) {
        this.copy(in, out, 1024);
    }

    public String getTmpPath(String name) {
        return new File(new File(System.getProperty("java.io.tmpdir"), "cargo"), name).getPath();
    }

    public synchronized String createUniqueTmpDirectory() {
        File tmpDir;
        if (uniqueNameCounter == -1) {
            uniqueNameCounter = new Random().nextInt() & 0xFFFF;
        }
        while ((tmpDir = new File(new File(System.getProperty("java.io.tmpdir")), "cargo/" + Integer.toString(++uniqueNameCounter))).exists()) {
        }
        tmpDir.deleteOnExit();
        tmpDir.mkdirs();
        return tmpDir.getPath();
    }

    public void delete(String path) {
        File pathAsFile = new File(path);
        if (pathAsFile.isDirectory()) {
            File[] children;
            for (File element : children = pathAsFile.listFiles()) {
                this.delete(element.getPath());
            }
        }
        pathAsFile.delete();
    }

    public long getSize(String file) {
        File fileObject = new File(file).getAbsoluteFile();
        if (!fileObject.isFile()) {
            throw new CargoException("File [" + file + "] is not a file");
        }
        return fileObject.length();
    }

    public InputStream getInputStream(String file) {
        FileInputStream is;
        try {
            is = new FileInputStream(new File(file).getAbsoluteFile());
        }
        catch (FileNotFoundException e) {
            throw new CargoException("Failed to find file [" + file + "]", e);
        }
        return is;
    }

    public OutputStream getOutputStream(String file) {
        FileOutputStream os;
        try {
            os = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new CargoException("Failed to open output stream for file [" + file + "]", e);
        }
        return os;
    }

    public String append(String path, String suffixToAppend) {
        String result = !path.endsWith("/") && !path.endsWith("\\") ? path + "/" + suffixToAppend : path + suffixToAppend;
        return result;
    }

    public void mkdirs(String path) {
        File pathFile = new File(path);
        boolean success = pathFile.exists() ? true : pathFile.mkdirs();
        if (!success) {
            throw new CargoException("Failed to create folders for path [" + path + "]");
        }
    }

    public String getParent(String path) {
        return new File(path).getParent();
    }

    public boolean exists(String path) {
        return new File(path).exists();
    }

    public void createFile(String file) {
        try {
            new File(file).createNewFile();
        }
        catch (IOException e) {
            throw new CargoException("Failed to create file [" + file + "]", e);
        }
    }

    public boolean isDirectoryEmpty(String dir) {
        return new File(dir).list().length == 0;
    }

    public String getName(String file) {
        return new File(file).getName();
    }

    public String getURL(String path) {
        URL result;
        try {
            result = new File(path).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new CargoException("Failed to return URL for [" + path + "]", e);
        }
        return result.toString();
    }

    public boolean isDirectory(String path) {
        return new File(path).isDirectory();
    }

    public String[] getChildren(String directory) {
        File[] files = new File(directory).listFiles();
        String[] results = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            results[i] = files[i].getPath();
        }
        return results;
    }

    public String getAbsolutePath(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir"), file.getPath());
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readTextFile(String file) {
        String string;
        block7: {
            BufferedReader in = null;
            StringBuilder out = new StringBuilder();
            try {
                String str;
                in = new BufferedReader(new InputStreamReader(this.getInputStream(file)));
                while ((str = in.readLine()) != null) {
                    out.append(str);
                }
                string = out.toString();
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CargoException("Failed to read text from file: " + file, e);
                }
            }
            in.close();
        }
        return string;
    }
}

