/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MissingXmlElementAppender {
    private final Document document;
    private final LinkedList<String> expressionNodes = new LinkedList();

    public MissingXmlElementAppender(Document document, String xPathString) {
        this.document = document;
        String regex = "/(?=(?:[^']*'[^']*')*[^']*$)";
        this.expressionNodes.addAll(Arrays.asList(xPathString.split(regex)));
    }

    public Document getDocument() {
        return this.document;
    }

    public Node append() throws XPathExpressionException {
        LinkedList<String> missingNodes = new LinkedList<String>();
        Node evaluate = this.getMostCommonNode(missingNodes);
        if (evaluate != null && !missingNodes.isEmpty()) {
            evaluate = this.appendMissingElements(missingNodes, evaluate);
        }
        return evaluate;
    }

    private Node getMostCommonNode(LinkedList<String> missingNodes) throws XPathExpressionException {
        Object evaluate;
        XPath xPath = XPathFactory.newInstance().newXPath();
        do {
            String expression;
            XPathExpression xPathExpression;
            if ((evaluate = (xPathExpression = xPath.compile(expression = this.toXPathString(this.expressionNodes))).evaluate(this.document, XPathConstants.NODE)) != null) continue;
            String lastNode = this.expressionNodes.removeLast();
            missingNodes.addFirst(lastNode);
        } while (evaluate == null && !this.expressionNodes.isEmpty());
        if (evaluate != null) {
            return (Node)evaluate;
        }
        return null;
    }

    private String toXPathString(List<String> expressionNodes) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = expressionNodes.iterator();
        while (iterator.hasNext()) {
            String expressionNode = iterator.next();
            stringBuilder.append(expressionNode);
            if (!iterator.hasNext()) continue;
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    private Node appendMissingElements(List<String> missingNodes, Node node) {
        Pattern elementOnlyPattern = Pattern.compile("([^\\[]+)\\[.+");
        Node result = node;
        for (String missingNode : missingNodes) {
            if (missingNode.startsWith("@")) continue;
            Matcher matcher = elementOnlyPattern.matcher(missingNode);
            if (matcher.matches()) {
                missingNode = matcher.group(1);
            }
            Element newElement = this.document.createElement(missingNode);
            result.appendChild(newElement);
            result = newElement;
        }
        return result;
    }
}

