/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.codehaus.cargo.util.FileHandler;

public class ZipCompressor {
    private FileHandler fileHandler;

    public ZipCompressor(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public void compress(String sourceDirectory, String targetFile) throws IOException {
        try (ZipOutputStream zipFile = new ZipOutputStream(this.fileHandler.getOutputStream(targetFile));){
            this.compressDirectory(sourceDirectory, sourceDirectory, zipFile);
        }
    }

    private void compressDirectory(String currentDirectory, String startDirectory, ZipOutputStream zipFile) throws IOException {
        for (String child : this.fileHandler.getChildren(currentDirectory, new String[0])) {
            ZipEntry entry;
            String childPath = child.replace(startDirectory, "").replace('\\', '/');
            if (childPath.startsWith("/")) {
                childPath = childPath.substring(1);
            }
            if (this.fileHandler.isDirectory(child)) {
                childPath = childPath + '/';
                entry = new ZipEntry(childPath);
                zipFile.putNextEntry(entry);
                this.compressDirectory(child, startDirectory, zipFile);
                continue;
            }
            entry = new ZipEntry(childPath);
            zipFile.putNextEntry(entry);
            try (InputStream content = this.fileHandler.getInputStream(child);){
                this.fileHandler.copy(content, zipFile);
            }
        }
    }
}

