/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util.log;

import org.codehaus.cargo.util.CargoException;

public final class LogLevel
implements Comparable<LogLevel> {
    public static final LogLevel WARN = new LogLevel("warn", 0);
    public static final LogLevel INFO = new LogLevel("info", 1);
    public static final LogLevel DEBUG = new LogLevel("debug", 2);
    private String level;
    private int logVolume;

    private LogLevel(String level, int logVolume) {
        this.level = level;
        this.logVolume = logVolume;
    }

    public static LogLevel toLevel(String levelAsString) {
        LogLevel level;
        if (levelAsString.equalsIgnoreCase(INFO.getLevel())) {
            level = INFO;
        } else if (levelAsString.equalsIgnoreCase(WARN.getLevel())) {
            level = WARN;
        } else if (levelAsString.equalsIgnoreCase(DEBUG.getLevel())) {
            level = DEBUG;
        } else {
            throw new CargoException("Invalid log level [" + levelAsString + "]. Valid values are \"debug\", \"info\" and \"warn\".");
        }
        return level;
    }

    public boolean equals(Object object) {
        LogLevel level;
        boolean result = false;
        if (object != null && object instanceof LogLevel && (level = (LogLevel)object).getLevel().equals(this.getLevel())) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        return this.level.hashCode();
    }

    @Override
    public int compareTo(LogLevel level) {
        int result = this.logVolume == level.logVolume ? 0 : (this.logVolume > level.logVolume ? 1 : -1);
        return result;
    }

    public String getLevel() {
        return this.level;
    }

    public String toString() {
        return this.getLevel();
    }
}

