/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.geronimo;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.geronimo.internal.GeronimoStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;

public class Geronimo1xStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new GeronimoStandaloneLocalConfigurationCapability();

    public Geronimo1xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.rmi.port", "1099");
        this.setProperty("cargo.remote.username", "system");
        this.setProperty("cargo.remote.password", "manager");
        this.setProperty("cargo.geronimo.log.console", "INFO");
        this.setProperty("cargo.geronimo.log.file", "DEBUG");
        this.setProperty("cargo.geronimo.servlet.containerId", "tomcat");
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        FilterChain filterChain = this.createGeronimoFilterChain(container);
        this.getFileHandler().createDirectory(this.getHome(), "/var/temp");
        this.copyExtraStuffTemporarily(new File(((InstalledLocalContainer)container).getHome()));
        String configDir = this.getFileHandler().createDirectory(this.getHome(), "var/config");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/" + this.getPropertyValue("cargo.geronimo.servlet.containerId") + "/config.xml", new File(configDir, "config.xml"), filterChain);
        String securityDir = this.getFileHandler().createDirectory(this.getHome(), "/var/security");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/users.properties", new File(securityDir, "users.properties"), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/groups.properties", new File(securityDir, "groups.properties"), filterChain);
        String keystoresDir = this.getFileHandler().createDirectory(securityDir, "keystores");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/keystore", new File(keystoresDir, "geronimo-default"));
        String logDir = this.getFileHandler().createDirectory(this.getHome(), "/var/log");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/server-log4j.properties", new File(logDir, "server-log4j.properties"), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/client-log4j.properties", new File(logDir, "client-log4j.properties"), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/deployer-log4j.properties", new File(logDir, "deployer-log4j.properties"), filterChain);
        String deployDir = this.getFileHandler().createDirectory(this.getHome(), "deploy");
        if (!this.getFileHandler().exists(deployDir)) {
            this.getFileHandler().mkdirs(deployDir);
        }
    }

    private void copyExtraStuffTemporarily(File containerHome) {
        File configStore = new File(containerHome, "config-store");
        if (configStore.isDirectory()) {
            Copy copyStore = (Copy)this.getAntUtils().createAntTask("copy");
            FileSet fileSetStore = new FileSet();
            fileSetStore.setDir(new File(containerHome, "config-store"));
            copyStore.addFileset(fileSetStore);
            copyStore.setTodir(new File(this.getHome(), "config-store"));
            copyStore.execute();
        }
        Copy copyBin = (Copy)this.getAntUtils().createAntTask("copy");
        FileSet fileSetBin = new FileSet();
        fileSetBin.setDir(new File(containerHome, "bin"));
        copyBin.addFileset(fileSetBin);
        copyBin.setTodir(new File(this.getHome(), "bin"));
        copyBin.execute();
        Copy copyLib = (Copy)this.getAntUtils().createAntTask("copy");
        FileSet fileSetLib = new FileSet();
        fileSetLib.setDir(new File(containerHome, "lib"));
        copyLib.addFileset(fileSetLib);
        copyLib.setTodir(new File(this.getHome(), "lib"));
        copyLib.execute();
        Copy copyRepo = (Copy)this.getAntUtils().createAntTask("copy");
        FileSet fileSetRepo = new FileSet();
        fileSetRepo.setDir(new File(containerHome, "repository"));
        copyRepo.addFileset(fileSetRepo);
        copyRepo.setTodir(new File(this.getHome(), "repository"));
        copyRepo.execute();
        Copy copySchema = (Copy)this.getAntUtils().createAntTask("copy");
        FileSet fileSetSchema = new FileSet();
        fileSetSchema.setDir(new File(containerHome, "schema"));
        copySchema.addFileset(fileSetSchema);
        copySchema.setTodir(new File(this.getHome(), "schema"));
        copySchema.execute();
    }

    protected FilterChain createGeronimoFilterChain(LocalContainer container) throws MalformedURLException {
        FilterChain filterChain = this.getFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.rmi.port", this.getPropertyValue("cargo.rmi.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.servlet.port", this.getPropertyValue("cargo.servlet.port"));
        String[] userTokens = this.getUserTokens();
        this.getAntUtils().addTokenToFilterChain(filterChain, "geronimo.users", userTokens[0]);
        this.getAntUtils().addTokenToFilterChain(filterChain, "geronimo.groups", userTokens[1]);
        this.getAntUtils().addTokenToFilterChain(filterChain, "geronimo.manager.username", this.getPropertyValue("cargo.remote.username"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "geronimo.manager.password", this.getPropertyValue("cargo.remote.password"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "geronimo.console.log.level", this.getPropertyValue("cargo.geronimo.log.console"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "geronimo.file.log.level", this.getPropertyValue("cargo.geronimo.log.file"));
        return filterChain;
    }

    private String[] getUserTokens() {
        String[] tokens = new String[]{" ", " "};
        StringBuilder usersToken = new StringBuilder("");
        StringBuilder groupsToken = new StringBuilder("");
        String usersString = this.getPropertyValue("cargo.geronimo.users");
        if (usersString != null) {
            Iterator users = User.parseUsers((String)usersString).iterator();
            HashMap groupUsersMapping = new HashMap();
            while (users.hasNext()) {
                User user = (User)users.next();
                usersToken.append(user.getName());
                usersToken.append('=');
                usersToken.append(user.getPassword());
                usersToken.append(System.getProperty("line.separator"));
                List roles = user.getRoles();
                for (int i = 0; i < roles.size(); ++i) {
                    HashSet<String> groupUsers = (HashSet<String>)groupUsersMapping.get(roles.get(i));
                    if (groupUsers == null) {
                        groupUsers = new HashSet<String>();
                        groupUsersMapping.put(roles.get(i), groupUsers);
                    }
                    groupUsers.add(user.getName());
                }
            }
            Set groups = groupUsersMapping.keySet();
            for (Object key : groups) {
                Set gUsers = (Set)groupUsersMapping.get(key);
                groupsToken.append(key);
                groupsToken.append('=');
                Iterator iter2 = gUsers.iterator();
                while (iter2.hasNext()) {
                    groupsToken.append(iter2.next());
                    if (!iter2.hasNext()) continue;
                    groupsToken.append(',');
                }
                groupsToken.append(System.getProperty("line.separator"));
            }
            tokens[0] = usersToken.toString();
            tokens[1] = groupsToken.toString();
        }
        return tokens;
    }
}

