/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Iterator;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.jboss.internal.JBossStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;

public class JBossStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new JBossStandaloneLocalConfigurationCapability();

    public JBossStandaloneLocalConfiguration(File dir) {
        super(dir);
        this.setProperty("cargo.jboss.rmi.port", "1299");
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.createConfigurationDir();
        FilterChain filterChain = this.createJBossFilterChain(container.getHome());
        this.getFileUtils().createDirectory(this.getHome(), "/deploy");
        this.getFileUtils().createDirectory(this.getHome(), "/lib");
        File confDir = this.getFileUtils().createDirectory(this.getHome(), "/conf");
        String[] cargoFiles = new String[]{"cargo-binding.xml", "log4j.xml", "jboss-service.xml"};
        for (int i = 0; i < cargoFiles.length; ++i) {
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/" + cargoFiles[i], new File(confDir, cargoFiles[i]), filterChain);
        }
        this.copyExternalResources(new File(container.getHome(), "server/default/conf"), confDir, cargoFiles);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(this.getHome().getPath(), "/deploy/cargocpc.war"));
    }

    private void copyExternalResources(File sourceDir, File destDir, String[] cargoFiles) throws FileNotFoundException, IOException {
        File[] sourceFiles = sourceDir.listFiles();
        for (int i = 0; i < sourceFiles.length; ++i) {
            if (this.isExcluded(cargoFiles, sourceFiles[i].getName())) continue;
            if (sourceFiles[i].isDirectory()) {
                this.getFileUtils().createDirectory(destDir, sourceFiles[i].getName());
                this.copyExternalResources(sourceFiles[i], new File(destDir, sourceFiles[i].getName()), cargoFiles);
                continue;
            }
            this.getFileUtils().copy((InputStream)new FileInputStream(sourceFiles[i]), (OutputStream)new FileOutputStream(new File(destDir, sourceFiles[i].getName())));
        }
    }

    private boolean isExcluded(String[] cargoFiles, String filename) {
        for (int i = 0; i < cargoFiles.length; ++i) {
            if (!cargoFiles[i].equals(filename)) continue;
            return true;
        }
        return false;
    }

    protected FilterChain createJBossFilterChain(File home) throws MalformedURLException {
        FilterChain filterChain = new FilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.binding.url", new File(this.getHome().getPath(), "conf/cargo-binding.xml").toURL().toString());
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.rmi.port", this.getPropertyValue("cargo.jboss.rmi.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.servlet.port", this.getPropertyValue("cargo.servlet.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.logging", this.getJBossLogLevel(this.getPropertyValue("cargo.logging")));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.server.lib.url", new File(home, "server/default/lib").toURL().toString());
        StringBuffer buffer = new StringBuffer();
        buffer.append("deploy/, ").append(new File(home, "server/default/deploy").toURL().toString());
        Iterator iterator = this.getDeployables().iterator();
        while (iterator.hasNext()) {
            Deployable deployable = (Deployable)iterator.next();
            if (deployable.getType() == DeployableType.WAR && ((WAR)deployable).isExpandedWar()) {
                String deployableURL = deployable.getFile().toURL().toString();
                buffer.append(", ").append(deployableURL.substring(0, deployableURL.length() - 1));
                continue;
            }
            buffer.append(", ").append(deployable.getFile().toURL().toString());
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.server.deploy.url", buffer.toString());
        return filterChain;
    }

    private String getJBossLogLevel(String cargoLogLevel) {
        String level = cargoLogLevel.equalsIgnoreCase("low") ? "ERROR" : (cargoLogLevel.equalsIgnoreCase("medium") ? "WARN" : "INFO");
        return level;
    }

    public String toString() {
        return "JBoss Standalone Configuration";
    }
}

