/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss.internal;

import java.io.File;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.jboss.internal.JBossContainerCapability;
import org.codehaus.cargo.container.spi.AbstractLocalContainer;

public abstract class AbstractJBossLocalContainer
extends AbstractLocalContainer {
    private ContainerCapability capability = new JBossContainerCapability();
    private String version;

    public AbstractJBossLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    protected void doStart(Java java) throws Exception {
        this.getConfiguration().configure((LocalContainer)this);
        java.addSysproperty(this.getAntUtils().createSysProperty("java.endorsed.dirs", new File(this.getHome(), "/lib/endorsed")));
        java.addSysproperty(this.getAntUtils().createSysProperty("jboss.home.dir", this.getHome()));
        java.addSysproperty(this.getAntUtils().createSysProperty("jboss.server.home.dir", this.getConfiguration().getHome().getPath()));
        java.addSysproperty(this.getAntUtils().createSysProperty("jboss.server.home.url", this.getConfiguration().getHome().toURL().toString()));
        java.addSysproperty(this.getAntUtils().createSysProperty("jboss.server.name", this.getId()));
        java.addSysproperty(this.getAntUtils().createSysProperty("jboss.server.lib.url", new File(this.getHome() + "/server/default/lib/").toURL().toString()));
        java.createJvmarg().setValue("-Xms128m");
        java.createJvmarg().setValue("-Xmx512m");
        java.createArg().setValue("--configuration=" + this.getId());
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(this.getHome(), "bin/run.jar"));
        this.addToolsJarToClasspath(classpath);
        java.setClassname("org.jboss.Main");
        AntContainerExecutorThread jbossRunner = new AntContainerExecutorThread(java);
        jbossRunner.start();
    }

    protected void doStop(Java java) throws Exception {
        Path classPath = java.createClasspath();
        classPath.createPathElement().setLocation(new File(this.getHome(), "bin/shutdown.jar"));
        java.setClassname("org.jboss.Shutdown");
        java.createArg().setValue("--server=" + this.getConfiguration().getPropertyValue("cargo.hostname") + ":" + this.getConfiguration().getPropertyValue("cargo.jboss.rmi.port"));
        AntContainerExecutorThread jbossRunner = new AntContainerExecutorThread(java);
        jbossRunner.start();
        Thread.sleep(2000L);
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    protected final String getVersion(String defaultVersion) {
        String version = this.version;
        if (version == null) {
            try {
                JarFile jarFile = new JarFile(new File(this.getHome(), "bin/run.jar"));
                ZipEntry entry = jarFile.getEntry("org/jboss/version.properties");
                if (entry != null) {
                    Properties properties = new Properties();
                    properties.load(jarFile.getInputStream(entry));
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(properties.getProperty("version.major"));
                    buffer.append(".");
                    buffer.append(properties.getProperty("version.minor"));
                    buffer.append(".");
                    buffer.append(properties.getProperty("version.revision"));
                    version = buffer.toString();
                } else {
                    version = defaultVersion;
                    this.getMonitor().debug("Couldn't find version.properties in " + jarFile.getName(), ((Object)((Object)this)).getClass().getName());
                }
            }
            catch (Exception e) {
                version = defaultVersion;
                this.getMonitor().debug("Failed to find JBoss version, base error [" + e.getMessage() + "]", ((Object)((Object)this)).getClass().getName());
            }
            this.getMonitor().info("Parsed JBoss version = [" + version + "]", ((Object)((Object)this)).getClass().getName());
            this.version = version;
        }
        return version;
    }
}

