/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty.internal;

import java.io.File;
import java.util.Iterator;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.jetty.internal.AbstractJettyEmbeddedLocalContainer;
import org.codehaus.cargo.container.jetty.internal.JettyExecutorThread;
import org.codehaus.cargo.container.property.User;

public abstract class AbstractJetty4x5xEmbeddedLocalContainer
extends AbstractJettyEmbeddedLocalContainer {
    static /* synthetic */ Class class$java$lang$Object;

    public AbstractJetty4x5xEmbeddedLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    protected void doStart() throws Exception {
        this.createServerObject();
        Class<?> listenerClass = this.getClassLoader().loadClass("org.mortbay.http.SocketListener");
        Object listener = listenerClass.newInstance();
        listenerClass.getMethod("setPort", Integer.TYPE).invoke(listener, new Integer(this.getConfiguration().getPropertyValue("cargo.servlet.port")));
        this.getServer().getClass().getMethod("addListener", this.getClassLoader().loadClass("org.mortbay.http.HttpListener")).invoke(this.getServer(), listener);
        this.setSecurityRealm();
        Iterator it = this.getConfiguration().getDeployables().iterator();
        while (it.hasNext()) {
            Deployable deployable = (Deployable)it.next();
            if (deployable.getType() == DeployableType.WAR) {
                Object webapp = this.getServer().getClass().getMethod("addWebApplication", class$java$lang$String == null ? AbstractJetty4x5xEmbeddedLocalContainer.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? AbstractJetty4x5xEmbeddedLocalContainer.class$("java.lang.String") : class$java$lang$String).invoke(this.getServer(), "/" + ((WAR)deployable).getContext(), deployable.getFile());
                this.performExtraSetupOnDeployable(webapp);
                continue;
            }
            throw new ContainerException("Only WAR archives are supported for deployment in Jetty. Got [" + deployable.getFile() + "]");
        }
        this.getServer().getClass().getMethod("addWebApplication", String.class, String.class).invoke(this.getServer(), "/cargocpc", new File(this.getConfiguration().getHome(), "cargocpc.war").getPath());
        JettyExecutorThread jettyRunner = new JettyExecutorThread(this.getServer(), true);
        jettyRunner.setLogger(this.getLogger());
        jettyRunner.start();
    }

    protected abstract void performExtraSetupOnDeployable(Object var1) throws Exception;

    protected void setSecurityRealm() throws Exception {
        if (this.getConfiguration().getPropertyValue("cargo.servlet.users") != null) {
            Class<?> realmClass = this.getClassLoader().loadClass("org.mortbay.http.HashUserRealm");
            Object defaultRealm = realmClass.getConstructor(String.class).newInstance("Cargo Test Realm");
            Iterator users = User.parseUsers((String)this.getConfiguration().getPropertyValue("cargo.servlet.users")).iterator();
            while (users.hasNext()) {
                User user = (User)users.next();
                defaultRealm.getClass().getMethod("put", class$java$lang$Object == null ? AbstractJetty4x5xEmbeddedLocalContainer.class$("java.lang.Object") : class$java$lang$Object, class$java$lang$Object == null ? AbstractJetty4x5xEmbeddedLocalContainer.class$("java.lang.Object") : class$java$lang$Object).invoke(defaultRealm, user.getName(), user.getPassword());
                Iterator roles = user.getRoles().iterator();
                while (roles.hasNext()) {
                    String role = (String)roles.next();
                    defaultRealm.getClass().getMethod("addUserToRole", class$java$lang$String == null ? AbstractJetty4x5xEmbeddedLocalContainer.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? AbstractJetty4x5xEmbeddedLocalContainer.class$("java.lang.String") : class$java$lang$String).invoke(defaultRealm, user.getName(), role);
                }
            }
            this.getServer().getClass().getMethod("addRealm", this.getClassLoader().loadClass("org.mortbay.http.UserRealm")).invoke(this.getServer(), defaultRealm);
        }
    }
}

