/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.jetty.Jetty9xInstalledLocalContainer;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;
import org.codehaus.cargo.util.CargoException;

public class Jetty10xInstalledLocalContainer
extends Jetty9xInstalledLocalContainer {
    public static final String ID = "jetty10x";
    public static final String DEFAULT_MODULES = "server,ext,http,annotations,plus,jsp,deploy";

    public Jetty10xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected String getJettyPortPropertyName() {
        return "jetty.http.port";
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    protected String[] getStartArguments(String classpath) {
        boolean keystoreFile;
        String configuredModules = this.getConfiguration().getPropertyValue("cargo.jetty.modules");
        if (configuredModules == null || configuredModules.trim().length() == 0) {
            throw new CargoException("Configuration property [cargo.jetty.modules] not set");
        }
        String[] modules = configuredModules.split(",");
        String[] startArguments = new String[modules.length + (classpath == null ? 0 : 1)];
        boolean httpsModule = false;
        for (int i = 0; i < modules.length; ++i) {
            startArguments[i] = "--module=" + modules[i];
            if (!"https".equals(modules[i])) continue;
            httpsModule = true;
        }
        boolean bl = keystoreFile = this.getConfiguration().getPropertyValue("cargo.jetty.connector.keystoreFile") != null;
        if (!(!httpsModule && !keystoreFile && !"https".equals(this.getConfiguration().getPropertyValue("cargo.protocol")) || httpsModule && keystoreFile)) {
            throw new CargoException("To enable HTTPS, you need to BOTH add the https module and provide the configuration value cargo.jetty.connector.keystoreFile");
        }
        if (classpath != null) {
            startArguments[startArguments.length - 1] = "path=" + classpath;
        }
        return startArguments;
    }

    @Override
    protected String[] getStopArguments() {
        return new String[]{"STOP.PORT=" + this.getConfiguration().getPropertyValue("cargo.rmi.port"), "STOP.KEY=secret"};
    }

    @Override
    protected void invoke(JvmLauncher java, boolean isGettingStarted) throws Exception {
        String keystoreFile = this.getConfiguration().getPropertyValue("cargo.jetty.connector.keystoreFile");
        if (keystoreFile != null) {
            String keystoreType;
            java.setSystemProperty("jetty.ssl.port", this.getConfiguration().getPropertyValue("cargo.jetty.connector.https.port"));
            java.setSystemProperty("jetty.sslContext.keyStorePath", keystoreFile);
            String keystorePassword = this.getConfiguration().getPropertyValue("cargo.jetty.connector.keystorePass");
            if (keystorePassword != null) {
                java.setSystemProperty("jetty.sslContext.keyStorePassword", keystorePassword);
            }
            if ((keystoreType = this.getConfiguration().getPropertyValue("cargo.jetty.connector.keystoreType")) != null) {
                java.setSystemProperty("jetty.sslContext.keyStoreType", keystoreType);
            }
        }
        super.invoke(java, isGettingStarted);
    }
}

