/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;

public abstract class AbstractJettyEmbeddedStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    public AbstractJettyEmbeddedStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.jetty.servlet.default.useFileMappedBuffer", "true");
        this.setProperty("cargo.jetty.deployer.createContextXml", "true");
        this.setProperty("cargo.jetty.realm.name", "Cargo Test Realm");
    }

    public abstract ConfigurationCapability getCapability();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConfigure(LocalContainer container) throws Exception {
        try {
            EmbeddedLocalContainer embeddedContainer = (EmbeddedLocalContainer)container;
            this.setupConfigurationDir();
            String etcDir = this.getFileHandler().createDirectory(this.getHome(), "etc");
            this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(this.getHome(), "cargocpc.war"));
            String webdefault = this.getFileHandler().append(etcDir, "webdefault.xml");
            this.getFileHandler().createFile(webdefault);
            InputStream webdefaultReader = null;
            try {
                webdefaultReader = embeddedContainer.getClassLoader().getResourceAsStream("org/mortbay/jetty/servlet/webdefault.xml");
                if (webdefaultReader == null) {
                    webdefaultReader = embeddedContainer.getClassLoader().getResourceAsStream("org/mortbay/jetty/webapp/webdefault.xml");
                }
                if (webdefaultReader == null) {
                    webdefaultReader = embeddedContainer.getClassLoader().getResourceAsStream("org/eclipse/jetty/webapp/webdefault.xml");
                }
                if (webdefaultReader == null) {
                    throw new FileNotFoundException("Cannot find the webdefault.xml file");
                }
                try (OutputStream webdefaultWriter = this.getFileHandler().getOutputStream(webdefault);){
                    this.getFileHandler().copy(webdefaultReader, webdefaultWriter);
                }
            }
            finally {
                if (webdefaultReader != null) {
                    webdefaultReader.close();
                }
                webdefaultReader = null;
            }
            if (container.getOutput() != null) {
                this.activateLogging(container);
            }
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + container.getName() + " container configuration", (Throwable)e);
        }
    }

    protected abstract void activateLogging(LocalContainer var1) throws Exception;
}

