/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.jetty.Jetty11xEmbeddedLocalContainer;
import org.codehaus.cargo.container.jetty.Jetty12xEmbeddedStandaloneLocalConfiguration;
import org.codehaus.cargo.util.CargoException;

public class Jetty12xEmbeddedLocalContainer
extends Jetty11xEmbeddedLocalContainer {
    public static final String ID = "jetty12x";

    public Jetty12xEmbeddedLocalContainer(LocalConfiguration configuration) {
        super((LocalConfiguration)((Jetty12xEmbeddedStandaloneLocalConfiguration)configuration));
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public Object createHandler(Deployable deployable) throws Exception {
        return this.nestHandler(super.createHandler(deployable));
    }

    @Override
    public Object createHandler(String contextPath, String war) throws Exception {
        return this.nestHandler(super.createHandler(contextPath, war));
    }

    private Object nestHandler(Object handler) throws Exception {
        String eeVersion = this.getEeVersion();
        if (!"ee10".equals(eeVersion)) {
            Class<?> handlerClass = this.getClassLoader().loadClass("org.eclipse.jetty." + eeVersion + ".nested.Handler");
            Class<?> nestedHandlerClass = this.getClassLoader().loadClass("org.eclipse.jetty." + eeVersion + ".nested.ContextHandler");
            Object nestedHandler = nestedHandlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            nestedHandlerClass.getMethod("setHandler", handlerClass).invoke(nestedHandler, handler);
            return nestedHandlerClass.getMethod("getCoreContextHandler", new Class[0]).invoke(nestedHandler, new Object[0]);
        }
        return handler;
    }

    private String getEeVersion() {
        return this.getConfiguration().getPropertyValue("cargo.jetty.deployer.ee.version");
    }

    @Override
    protected synchronized void createServerObject() throws Exception {
        if (this.server == null) {
            super.createServerObject();
            Class<?> webAppClassLoadingClass = this.getClassLoader().loadClass("org.eclipse.jetty.ee.WebAppClassLoading");
            if (webAppClassLoadingClass.getPackage().getImplementationVersion() != null && webAppClassLoadingClass.getPackage().getImplementationVersion().startsWith("12.")) {
                Object defaultHiddenClasses = webAppClassLoadingClass.getDeclaredField("DEFAULT_HIDDEN_CLASSES").get(null);
                Method remove = defaultHiddenClasses.getClass().getMethod("remove", Object.class);
                remove.invoke(defaultHiddenClasses, "org.eclipse.jetty.");
            }
        }
    }

    @Override
    protected void addJettyHandlers() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Constructor<?>[] contextHandlerConstructors;
        this.handlerClass = this.getClassLoader().loadClass("org.eclipse.jetty.server.Handler");
        for (Constructor<?> contextHandlerConstructor : contextHandlerConstructors = this.getClassLoader().loadClass("org.eclipse.jetty.server.handler.ContextHandlerCollection").getDeclaredConstructors()) {
            if (!contextHandlerConstructor.getParameterTypes()[0].equals(Boolean.TYPE)) continue;
            this.contextHandlers = contextHandlerConstructor.newInstance(true, Array.newInstance(this.getClassLoader().loadClass("org.eclipse.jetty.server.handler.ContextHandler"), 0));
            break;
        }
        if (this.contextHandlers == null) {
            throw new CargoException("No valid ContextHandlerCollection constructor found");
        }
        Object defaultHandler = this.getClassLoader().loadClass("org.eclipse.jetty.server.handler.DefaultHandler").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ArrayList<Object> handlerList = new ArrayList<Object>(2);
        handlerList.add(this.contextHandlers);
        handlerList.add(defaultHandler);
        this.handlers = this.getClassLoader().loadClass("org.eclipse.jetty.server.Handler$Sequence").getDeclaredConstructor(List.class).newInstance(handlerList);
        this.getServer().getClass().getMethod("setHandler", this.handlerClass).invoke(this.getServer(), this.handlers);
        this.addHandlerMethod = this.contextHandlers.getClass().getMethod("addHandler", this.handlerClass);
        this.removeHandlerMethod = this.contextHandlers.getClass().getMethod("removeHandler", this.handlerClass);
    }

    @Override
    protected void addAnnotationConfiguration() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.setAttributeMethod().invoke(this.getServer(), "org.eclipse.jetty." + this.getEeVersion() + ".webapp.configuration", new String[]{"org.eclipse.jetty." + this.getEeVersion() + ".webapp.WebInfConfiguration", "org.eclipse.jetty." + this.getEeVersion() + ".webapp.WebXmlConfiguration", "org.eclipse.jetty." + this.getEeVersion() + ".webapp.MetaInfConfiguration", "org.eclipse.jetty." + this.getEeVersion() + ".webapp.FragmentConfiguration", "org.eclipse.jetty." + this.getEeVersion() + ".annotations.AnnotationConfiguration", "org.eclipse.jetty." + this.getEeVersion() + ".webapp.JettyWebXmlConfiguration"});
    }

    @Override
    protected String getWebappContextClassname() {
        return "org.eclipse.jetty." + this.getEeVersion() + ".webapp.WebAppContext";
    }
}

