/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.internal.http.HttpFileRequest;
import org.codehaus.cargo.container.internal.http.HttpRequest;
import org.codehaus.cargo.container.internal.http.HttpResult;
import org.codehaus.cargo.container.spi.deployer.AbstractRemoteDeployer;

public class JettyRemoteDeployer
extends AbstractRemoteDeployer {
    private static final String DEFAULT_DEPLOYER_CONTEXT = "cargo-jetty-deployer";
    private String username;
    private String password;
    private String deployerUrl;
    private int timeout = 0;

    public JettyRemoteDeployer(RemoteContainer container) {
        super(container);
        RuntimeConfiguration configuration = container.getConfiguration();
        this.username = configuration.getPropertyValue("cargo.remote.username");
        this.password = configuration.getPropertyValue("cargo.remote.password");
        this.deployerUrl = configuration.getPropertyValue("cargo.jetty.deployer.url");
        String timeoutStr = configuration.getPropertyValue("cargo.remote.timeout");
        if (timeoutStr != null && !timeoutStr.isEmpty()) {
            this.timeout = Integer.parseInt(timeoutStr);
        }
        if (this.deployerUrl == null) {
            this.deployerUrl = this.createDefaultDeployerUrl((Configuration)configuration);
        }
    }

    protected String createDefaultDeployerUrl(Configuration configuration) {
        String protocol = configuration.getPropertyValue("cargo.protocol");
        String host = configuration.getPropertyValue("cargo.hostname");
        String port = configuration.getPropertyValue("cargo.servlet.port");
        String deployerUrl = protocol + "://" + host + ":" + port + "/" + DEFAULT_DEPLOYER_CONTEXT;
        return deployerUrl;
    }

    public void deploy(Deployable deployable) {
        try {
            WAR war = (WAR)deployable;
            String path = URLEncoder.encode(war.getContext(), StandardCharsets.UTF_8.name());
            this.invoke("/deploy?path=/" + path, new File(war.getFile()));
        }
        catch (IOException e) {
            throw new ContainerException("Failed to deploy [" + deployable.getFile() + "]", (Throwable)e);
        }
    }

    public void undeploy(Deployable deployable) {
        try {
            WAR war = (WAR)deployable;
            String path = URLEncoder.encode(war.getContext(), StandardCharsets.UTF_8.name());
            this.invoke("/undeploy?path=/" + path);
        }
        catch (IOException e) {
            throw new ContainerException("Failed to undeploy [" + deployable + "]", (Throwable)e);
        }
    }

    protected void invoke(String path) throws IOException {
        this.invoke(path, null);
    }

    protected String invoke(String path, File fileData) throws IOException {
        HttpResult response;
        HttpRequest request;
        this.getLogger().debug("Invoking Jetty remote deployer using path [" + path + "]", ((Object)((Object)this)).getClass().getName());
        URL invokeURL = new URL(this.deployerUrl + path);
        if (fileData == null) {
            this.getLogger().debug("Performing GET request", ((Object)((Object)this)).getClass().getName());
            request = new HttpRequest(invokeURL, (long)this.timeout);
            request.setLogger(this.getLogger());
            request.setAuthentication(this.username, this.password);
            response = request.get();
        } else {
            this.getLogger().debug("Performing PUT request", ((Object)((Object)this)).getClass().getName());
            request = new HttpFileRequest(invokeURL, fileData, (long)this.timeout);
            request.setLogger(this.getLogger());
            request.setAuthentication(this.username, this.password);
            response = request.put();
        }
        if (!response.isSuccessful()) {
            throw new IOException("HTTP request failed, response code: " + response.getResponseCode() + ", response message: " + response.getResponseMessage() + ", response body: " + response.getResponseBody());
        }
        String responseBody = response.getResponseBody();
        if (responseBody == null || !this.lastLine(responseBody).startsWith("OK -") && !this.lastLine(responseBody).startsWith("Webapp deployed at context ")) {
            throw new ContainerException("The Jetty remote deployer webapp responded \"" + response + "\" instead of the expected success message");
        }
        return responseBody;
    }

    protected String lastLine(String string) throws IOException {
        try (BufferedReader reader = new BufferedReader(new StringReader(string));){
            String lastNonNullLine = "";
            String lastLine = null;
            while ((lastLine = reader.readLine()) != null) {
                if ("".equals(lastLine)) continue;
                lastNonNullLine = lastLine;
            }
            String string2 = lastNonNullLine;
            return string2;
        }
    }
}

