/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty.internal;

import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.util.log.Loggable;
import org.codehaus.cargo.util.log.Logger;
import org.codehaus.cargo.util.log.NullLogger;

public class JettyExecutorThread
extends Thread
implements Loggable {
    private Logger log = new NullLogger();
    private Object server;
    private boolean isForStart;

    public JettyExecutorThread(Object server, boolean isForStart) {
        this.server = server;
        this.isForStart = isForStart;
    }

    @Override
    public void run() {
        try {
            if (this.isForStart) {
                this.server.getClass().getMethod("start", new Class[0]).invoke(this.server, new Object[0]);
                try {
                    Object threadPool = this.server.getClass().getMethod("getThreadPool", new Class[0]).invoke(this.server, new Object[0]);
                    threadPool.getClass().getMethod("join", new Class[0]).invoke(threadPool, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    this.getLogger().info("Ignoring unimplemented method server.getThreadPool().join()", this.getClass().getName());
                }
            } else {
                this.server.getClass().getMethod("stop", new Class[0]).invoke(this.server, new Object[0]);
                try {
                    this.server.getClass().getMethod("destroy", new Class[0]).invoke(this.server, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    this.getLogger().info("Ignoring unimplemented method server.destroy()", this.getClass().getName());
                }
            }
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof IllegalStateException && "!STOPPED".equals(e.getCause().getMessage())) {
                return;
            }
            String message = "Failed to " + (this.isForStart ? "start" : "stop") + " the Jetty container";
            this.getLogger().warn(message + ": " + e, this.getClass().getName());
            throw new ContainerException(message, (Throwable)e);
        }
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public Logger getLogger() {
        return this.log;
    }
}

