/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.jetty.Jetty7xEmbeddedLocalContainer;
import org.codehaus.cargo.container.jetty.internal.AbstractJettyEmbeddedLocalDeployer;

public class Jetty7x8x9x10x11xEmbeddedLocalDeployer
extends AbstractJettyEmbeddedLocalDeployer {
    private Class webAppContextClass;

    public Jetty7x8x9x10x11xEmbeddedLocalDeployer(EmbeddedLocalContainer container) {
        super(container);
        try {
            this.webAppContextClass = ((Jetty7xEmbeddedLocalContainer)this.getContainer()).getClassLoader().loadClass(this.getWebappContextClassname());
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create Eclipse Jetty embedded local deployer", (Throwable)e);
        }
    }

    protected String getWebappContextClassname() {
        return "org.eclipse.jetty.webapp.WebAppContext";
    }

    @Override
    public Object deployWebApp(Deployable deployable) {
        this.getLogger().info("Deploying [" + deployable.getFile() + "]", ((Object)((Object)this)).getClass().getName());
        if (deployable.getType() == DeployableType.WAR) {
            try {
                Jetty7xEmbeddedLocalContainer container = (Jetty7xEmbeddedLocalContainer)this.getContainer();
                Object webAppContext = container.createHandler(deployable);
                container.addHandler(webAppContext);
                String[] virtualHosts = this.getVirtualHosts();
                if (virtualHosts != null) {
                    Method setVirtualHosts = this.webAppContextClass.getMethod("setVirtualHosts", virtualHosts.getClass());
                    if (setVirtualHosts.getParameterTypes()[0].isAssignableFrom(List.class)) {
                        setVirtualHosts.invoke(webAppContext, Arrays.asList(virtualHosts));
                    } else {
                        setVirtualHosts.invoke(webAppContext, new Object[]{virtualHosts});
                    }
                }
                if (this.getExtractWar() != null) {
                    this.webAppContextClass.getMethod("setExtractWAR", Boolean.TYPE).invoke(webAppContext, this.getExtractWar());
                }
                if (this.getCopyWebApp() != null) {
                    this.webAppContextClass.getMethod("setCopyDir", Boolean.TYPE).invoke(webAppContext, this.getCopyWebApp());
                }
                if (this.getParentLoaderPriority() != null) {
                    this.webAppContextClass.getMethod("setParentLoaderPriority", Boolean.TYPE).invoke(webAppContext, this.getParentLoaderPriority());
                }
                return webAppContext;
            }
            catch (Exception e) {
                throw new ContainerException("Failed to deploy [" + deployable.getFile() + "]", (Throwable)e);
            }
        }
        throw new ContainerException("Only WAR archives are supported for deployment in Jetty. Got [" + deployable.getFile() + "]");
    }

    @Override
    public void undeployWebApp(Deployable deployable) {
        this.stop(deployable);
        Jetty7xEmbeddedLocalContainer container = (Jetty7xEmbeddedLocalContainer)this.getContainer();
        Object deployedWebAppContext = Jetty7x8x9x10x11xEmbeddedLocalDeployer.getDeployedWebAppContext(deployable);
        try {
            container.removeHandler(deployedWebAppContext);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to undeploy [" + deployable.getFile() + "]", (Throwable)e);
        }
    }

    public void start(Deployable deployable) {
        try {
            Object deployedWebAppContext = Jetty7x8x9x10x11xEmbeddedLocalDeployer.getDeployedWebAppContext(deployable);
            this.webAppContextClass.getMethod("start", new Class[0]).invoke(deployedWebAppContext, new Object[0]);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to start [" + deployable.getFile() + "]", (Throwable)e);
        }
    }

    public void stop(Deployable deployable) {
        try {
            Object deployedWebAppContext = Jetty7x8x9x10x11xEmbeddedLocalDeployer.getDeployedWebAppContext(deployable);
            this.webAppContextClass.getMethod("stop", new Class[0]).invoke(deployedWebAppContext, new Object[0]);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to stop [" + deployable.getFile() + "]", (Throwable)e);
        }
    }
}

