/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.ServletContainerCapability;
import org.codehaus.cargo.container.jetty.internal.JettyExecutorThread;
import org.codehaus.cargo.container.spi.AbstractEmbeddedLocalContainer;
import org.codehaus.cargo.util.CargoException;

public abstract class AbstractJettyEmbeddedLocalContainer
extends AbstractEmbeddedLocalContainer {
    protected Object server;
    private ContainerCapability capability = new ServletContainerCapability();
    private String version;

    public AbstractJettyEmbeddedLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public Object getServer() {
        return this.server;
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
        if (waitForStarting) {
            long timeout = System.currentTimeMillis() + this.getTimeout();
            while (System.currentTimeMillis() < timeout) {
                Boolean started;
                Method isStarted;
                Thread.sleep(1000L);
                try {
                    isStarted = this.getServer().getClass().getMethod("isStarted", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new ContainerException("Cannot find method isStarted", (Throwable)e);
                }
                try {
                    started = (Boolean)isStarted.invoke(this.getServer(), new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new ContainerException("Cannot execute method isStarted", (Throwable)e);
                }
                if (!started.booleanValue()) continue;
                return;
            }
            throw new ContainerException("Server did not start after " + Long.toString(this.getTimeout()) + " milliseconds");
        }
        super.waitForCompletion(waitForStarting);
    }

    protected synchronized void createServerObject() throws Exception {
        if (this.server == null) {
            try {
                this.server = this.getClassLoader().loadClass("org.mortbay.jetty.Server").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ContainerException("Failed to create Jetty Server instance", (Throwable)e);
            }
        }
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    protected void doStop() throws Exception {
        this.createServerObject();
        JettyExecutorThread jettyRunner = new JettyExecutorThread(this.getServer(), false);
        jettyRunner.setLogger(this.getLogger());
        jettyRunner.start();
    }

    protected synchronized String getVersion() {
        if (this.version == null) {
            try {
                this.createServerObject();
            }
            catch (Exception e) {
                throw new CargoException("Cannot create Jetty embedded server", (Throwable)e);
            }
            this.version = this.server.getClass().getPackage().getImplementationVersion();
            if (this.version == null) {
                throw new CargoException("The class " + this.server.getClass() + " doesn't have any Implementation Version");
            }
            this.version = this.version + " Embedded";
        }
        return this.version;
    }
}

