/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.resin;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.resin.ResinDeployer;
import org.codehaus.cargo.container.spi.configuration.AbstractExistingLocalConfiguration;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfigurationCapability;

public class ResinExistingLocalConfiguration
extends AbstractExistingLocalConfiguration {
    public ResinExistingLocalConfiguration(File dir) {
        super(dir);
    }

    public ConfigurationCapability getCapability() {
        return new AbstractStandaloneLocalConfigurationCapability(){

            protected Map getPropertySupportMap() {
                return new HashMap();
            }
        };
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        File webappsDir = new File(this.getHome().getPath(), "webapps");
        if (!webappsDir.exists()) {
            throw new ContainerException("Invalid existing configuration: The [" + webappsDir.getPath() + "] directory does not exist");
        }
        ResinDeployer deployer = new ResinDeployer(container);
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(webappsDir, "cargocpc.war"));
    }

    public void verifyProperties() {
    }

    public String toString() {
        return "Resin Existing Configuration";
    }
}

