/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.resin.internal;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.resin.ResinDeployer;
import org.codehaus.cargo.container.resin.internal.ResinStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;

public abstract class AbstractResinStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new ResinStandaloneLocalConfigurationCapability();
    private File resinConf;
    private FileUtils fileUtils = FileUtils.newFileUtils();

    public AbstractResinStandaloneLocalConfiguration(File dir) {
        super(dir);
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    public final void setResinConf(File config) {
        this.resinConf = config;
    }

    protected File getResinConf() {
        return this.resinConf;
    }

    protected abstract void prepareAdditions(Container var1, FilterChain var2) throws IOException;

    protected abstract FilterChain createResinFilterChain();

    protected void doConfigure(LocalContainer container) throws Exception {
        this.createConfigurationDir();
        FilterChain filterChain = this.createResinFilterChain();
        if (this.getResinConf() != null) {
            this.fileUtils.copyFile(this.getResinConf(), new File(this.getHome().getPath(), "resin.conf"));
        } else {
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/resin.conf", new File(this.getHome().getPath(), "resin.conf"), filterChain);
        }
        File webappsDir = this.getFileUtils().createDirectory(this.getHome(), "webapps");
        ResinDeployer deployer = new ResinDeployer(container);
        deployer.setShouldDeployExpandedWARs(false);
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(webappsDir, "cargocpc.war"));
        this.prepareAdditions((Container)container, filterChain);
    }

    protected String createExpandedWarTokenValue(String dirAttribute) {
        StringBuffer expandedWarValue = new StringBuffer(" ");
        Iterator it = this.getDeployables().iterator();
        while (it.hasNext()) {
            Deployable deployable = (Deployable)it.next();
            if (deployable.getType() != DeployableType.WAR || !((WAR)deployable).isExpandedWar()) continue;
            File tmp = new File(this.getHome().getPath(), "tmp/" + ((WAR)deployable).getContext());
            File work = new File(this.getHome().getPath(), "work/" + ((WAR)deployable).getContext());
            expandedWarValue.append("<web-app id='");
            expandedWarValue.append(((WAR)deployable).getContext());
            expandedWarValue.append("' " + dirAttribute + "='");
            expandedWarValue.append(((WAR)deployable).getFile());
            expandedWarValue.append("'><temp-dir>");
            expandedWarValue.append(tmp.getPath());
            expandedWarValue.append("</temp-dir><work-dir>");
            expandedWarValue.append(work.getPath());
            expandedWarValue.append("</work-dir></web-app>");
        }
        return expandedWarValue.toString();
    }

    protected String getSecurityToken(String prefix, String suffix) {
        StringBuffer token = new StringBuffer(" ");
        if (this.getPropertyValue("cargo.servlet.users") != null) {
            Iterator users = User.parseUsers((String)this.getPropertyValue("cargo.servlet.users")).iterator();
            while (users.hasNext()) {
                User user = (User)users.next();
                token.append(prefix);
                token.append(user.getName());
                token.append(':');
                token.append(user.getPassword());
                token.append(':');
                Iterator roles = user.getRoles().iterator();
                while (roles.hasNext()) {
                    String role = (String)roles.next();
                    token.append(role);
                    if (!roles.hasNext()) continue;
                    token.append(',');
                }
                token.append(suffix);
            }
        }
        return token.toString();
    }

    public String toString() {
        return "Resin Standalone Configuration";
    }
}

