/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.resin;

import java.io.File;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.resin.ResinInstalledLocalDeployer;
import org.codehaus.cargo.container.resin.internal.ResinExistingLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractExistingLocalConfiguration;

public class ResinExistingLocalConfiguration
extends AbstractExistingLocalConfiguration {
    private static ConfigurationCapability capability = new ResinExistingLocalConfigurationCapability();

    public ResinExistingLocalConfiguration(String dir) {
        super(dir);
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        InstalledLocalContainer resinContainer = (InstalledLocalContainer)container;
        File webappsDir = new File(this.getHome(), "webapps");
        if (!webappsDir.exists()) {
            throw new ContainerException("Invalid existing configuration: The [" + webappsDir.getPath() + "] directory does not exist");
        }
        ResinInstalledLocalDeployer deployer = new ResinInstalledLocalDeployer(resinContainer);
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(webappsDir, "cargocpc.war"));
    }

    public String toString() {
        return "Resin Existing Configuration";
    }
}

