/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.resin.internal;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.resin.ResinInstalledLocalDeployer;
import org.codehaus.cargo.container.resin.internal.ResinStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.builder.AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder;

public abstract class AbstractResinStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder {
    private static ConfigurationCapability capability = new ResinStandaloneLocalConfigurationCapability();

    public AbstractResinStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    public String getOrCreateDataSourceConfigurationFile(DataSource ds, LocalContainer container) {
        return this.getOrCreateResourceConfigurationFile(null, container);
    }

    protected String getOrCreateResourceConfigurationFile(Resource resource, LocalContainer container) {
        String path = this.getFileHandler().append(this.getHome(), "conf");
        return this.getFileHandler().append(path, "resin.conf");
    }

    protected String getXpathForDataSourcesParent() {
        return this.getXpathForResourcesParent();
    }

    protected abstract void prepareAdditions(Container var1, FilterChain var2) throws IOException;

    protected abstract FilterChain createResinFilterChain();

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        InstalledLocalContainer resinContainer = (InstalledLocalContainer)container;
        FilterChain filterChain = this.createResinFilterChain();
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/resin.conf", this.getFileHandler().append(confDir, "resin.conf"), this.getFileHandler(), this.getFilterChain());
        String webappsDir = this.getFileHandler().createDirectory(this.getHome(), "webapps");
        ResinInstalledLocalDeployer deployer = new ResinInstalledLocalDeployer(resinContainer);
        deployer.setShouldDeployExpandedWARs(false);
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", this.getFileHandler().append(webappsDir, "cargocpc.war"), this.getFileHandler());
        this.prepareAdditions((Container)resinContainer, filterChain);
    }

    protected String createExpandedWarTokenValue(String dirAttribute) {
        StringBuilder expandedWarValue = new StringBuilder(" ");
        for (Deployable deployable : this.getDeployables()) {
            if (deployable.getType() != DeployableType.WAR || !((WAR)deployable).isExpandedWar()) continue;
            File tmp = new File(this.getHome(), "tmp/" + ((WAR)deployable).getContext());
            File work = new File(this.getHome(), "work/" + ((WAR)deployable).getContext());
            expandedWarValue.append("<web-app id='");
            expandedWarValue.append(((WAR)deployable).getContext());
            expandedWarValue.append("' " + dirAttribute + "='");
            expandedWarValue.append(((WAR)deployable).getFile());
            expandedWarValue.append("'><temp-dir>");
            expandedWarValue.append(tmp.getPath());
            expandedWarValue.append("</temp-dir><work-dir>");
            expandedWarValue.append(work.getPath());
            expandedWarValue.append("</work-dir></web-app>");
        }
        return expandedWarValue.toString();
    }

    protected String getSecurityToken(String prefix, String suffix) {
        StringBuilder token = new StringBuilder(" ");
        if (this.getPropertyValue("cargo.servlet.users") != null) {
            for (User user : User.parseUsers((String)this.getPropertyValue("cargo.servlet.users"))) {
                token.append(prefix);
                token.append(user.getName());
                token.append(':');
                token.append(user.getPassword());
                token.append(':');
                Iterator roles = user.getRoles().iterator();
                while (roles.hasNext()) {
                    String role = (String)roles.next();
                    token.append(role);
                    if (!roles.hasNext()) continue;
                    token.append(',');
                }
                token.append(suffix);
            }
        }
        return token.toString();
    }

    public String toString() {
        return "Resin Standalone Configuration";
    }
}

