/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingDeployer;
import org.codehaus.cargo.container.tomcat.TomcatWAR;
import org.codehaus.cargo.util.FileUtils;

public class TomcatCopyingLocalDeployer
extends AbstractCopyingDeployer {
    private FileUtils fileUtils = new FileUtils();
    private boolean shouldCopyWars = true;

    public TomcatCopyingLocalDeployer(LocalContainer container) {
        super(container);
    }

    public File getDeployableDir() {
        return new File(this.getContainer().getConfiguration().getHome().getPath(), "webapps");
    }

    public void setShouldCopyWars(boolean shouldCopyWars) {
        this.shouldCopyWars = shouldCopyWars;
    }

    protected void deployWar(File deployableDir, WAR war) throws Exception {
        if (war instanceof TomcatWAR) {
            TomcatWAR tomcatWar = (TomcatWAR)war;
            if (tomcatWar.containsContextFile()) {
                super.deployWar(deployableDir, war);
            } else if (this.shouldCopyWars) {
                super.deployWar(deployableDir, war);
            }
        } else if (this.shouldCopyWars) {
            super.deployWar(deployableDir, war);
        }
    }

    protected void deployExpandedWar(File deployableDir, WAR war) throws Exception {
        if (war instanceof TomcatWAR) {
            TomcatWAR tomcatWar = (TomcatWAR)war;
            if (tomcatWar.containsContextFile()) {
                File contextDir = this.fileUtils.createDirectory(this.getContainer().getConfiguration().getHome(), "conf/Catalina/" + this.getContainer().getConfiguration().getPropertyValue("cargo.hostname"));
                this.getFileUtils().copyFile(new File(tomcatWar.getFile(), "META-INF/context.xml"), new File(contextDir, tomcatWar.getFile().getName() + ".xml"), null, true);
            } else if (this.shouldCopyWars) {
                super.deployExpandedWar(deployableDir, war);
            }
        } else if (this.shouldCopyWars) {
            super.deployExpandedWar(deployableDir, war);
        }
    }
}

