/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractExistingLocalConfiguration;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.tomcat.TomcatCopyingLocalDeployer;

public class TomcatExistingLocalConfiguration
extends AbstractExistingLocalConfiguration {
    public TomcatExistingLocalConfiguration(File dir) {
        super(dir);
    }

    public ConfigurationCapability getCapability() {
        return new AbstractStandaloneLocalConfigurationCapability(){

            protected Map getPropertySupportMap() {
                return new HashMap();
            }
        };
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        File webappsDir = new File(this.getHome().getPath(), "webapps");
        if (!webappsDir.exists()) {
            throw new ContainerException("Invalid existing configuration: The [" + webappsDir.getPath() + "] directory does not exist");
        }
        TomcatCopyingLocalDeployer deployer = new TomcatCopyingLocalDeployer(container);
        deployer.setShouldDeployExpandedWARs(true);
        deployer.setShouldCopyWars(true);
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(webappsDir, "cargocpc.war"));
    }

    public void verifyProperties() {
    }

    public String toString() {
        return "Tomcat Existing Configuration";
    }
}

