/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.tomcat.internal.AbstractTomcatLocalContainer;

public abstract class AbstractCatalinaLocalContainer
extends AbstractTomcatLocalContainer {
    private String version;

    public AbstractCatalinaLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    protected final String getVersion(String defaultVersion) {
        String version = this.version;
        if (version == null) {
            try {
                JarFile catalinaJar = new JarFile(new File(this.getHome(), "server/lib/catalina.jar"));
                ZipEntry entry = catalinaJar.getEntry("org/apache/catalina/util/ServerInfo.properties");
                if (entry != null) {
                    Properties props = new Properties();
                    props.load(catalinaJar.getInputStream(entry));
                    String serverInfo = props.getProperty("server.info");
                    if (serverInfo.indexOf(47) > 0) {
                        version = serverInfo.substring(serverInfo.indexOf(47) + 1);
                    }
                } else {
                    version = "4.0.x";
                }
            }
            catch (Exception e) {
                version = defaultVersion;
                this.getMonitor().debug("Failed to find Tomcat version, base error [" + e.getMessage() + "]", ((Object)((Object)this)).getClass().getName());
            }
            this.getMonitor().debug("Parsed Tomcat version = [" + version + "]", ((Object)((Object)this)).getClass().getName());
            this.version = version;
        }
        return version;
    }

    protected final void invokeContainer(String action, Java java) throws Exception {
        java.addSysproperty(this.getAntUtils().createSysProperty("catalina.home", this.getHome()));
        java.addSysproperty(this.getAntUtils().createSysProperty("catalina.base", this.getConfiguration().getHome()));
        File tempFile = new File(this.getConfiguration().getHome().getPath(), "temp");
        java.addSysproperty(this.getAntUtils().createSysProperty("java.io.tmpdir", tempFile));
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(this.getHome(), "bin/bootstrap.jar"));
        this.addToolsJarToClasspath(classpath);
        java.setClassname("org.apache.catalina.startup.Bootstrap");
        java.createArg().setValue(action);
        AntContainerExecutorThread catalinaRunner = new AntContainerExecutorThread(java);
        catalinaRunner.start();
    }
}

