/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.tomcat.TomcatCopyingLocalDeployer;
import org.codehaus.cargo.container.tomcat.TomcatWAR;
import org.codehaus.cargo.container.tomcat.internal.AbstractTomcatStandaloneLocalConfiguration;

public abstract class AbstractCatalinaStandaloneLocalConfiguration
extends AbstractTomcatStandaloneLocalConfiguration {
    public AbstractCatalinaStandaloneLocalConfiguration(File dir) {
        super(dir);
        this.setProperty("cargo.servlet.users", "admin::manager");
        this.setProperty("cargo.tomcat.shutdown.port", "8205");
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.createConfigurationDir();
        FilterChain filterChain = this.createTomcatFilterChain();
        this.getFileUtils().createDirectory(this.getHome(), "temp");
        this.getFileUtils().createDirectory(this.getHome(), "logs");
        File confDir = this.getFileUtils().createDirectory(this.getHome(), "conf");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/server.xml", new File(confDir, "server.xml"), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/tomcat-users.xml", new File(confDir, "tomcat-users.xml"), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/web.xml", new File(confDir, "web.xml"));
        this.setupManager(container);
        this.setupWebApps(container);
    }

    protected abstract void setupManager(LocalContainer var1);

    private void setupWebApps(LocalContainer container) {
        try {
            File appDir = this.getFileUtils().createDirectory(this.getHome(), "webapps");
            TomcatCopyingLocalDeployer deployer = new TomcatCopyingLocalDeployer(container);
            deployer.setShouldDeployExpandedWARs(true);
            deployer.setShouldCopyWars(false);
            deployer.deploy(this.getDeployables());
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + container.getName() + " container configuration", (Throwable)e);
        }
    }

    private String getTomcatLoggingLevel(String cargoLoggingLevel) {
        String level = cargoLoggingLevel.equalsIgnoreCase("low") ? "1" : (cargoLoggingLevel.equalsIgnoreCase("medium") ? "2" : "4");
        return level;
    }

    protected FilterChain createTomcatFilterChain() {
        FilterChain filterChain = this.createFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.logging.level", this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.tomcat.shutdown.port", this.getPropertyValue("cargo.tomcat.shutdown.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat.users", this.getSecurityToken());
        StringBuffer webappTokenValue = new StringBuffer(" ");
        Iterator it = this.getDeployables().iterator();
        while (it.hasNext()) {
            TomcatWAR tomcatWar;
            Deployable deployable = (Deployable)it.next();
            if (deployable.getType() != DeployableType.WAR) {
                throw new ContainerException("Only WAR archives are supported for deployment in Tomcat. Got [" + deployable.getFile() + "]");
            }
            if (deployable instanceof TomcatWAR && (tomcatWar = (TomcatWAR)deployable).containsContextFile()) continue;
            webappTokenValue.append(this.createContextToken((WAR)deployable));
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat.webapps", webappTokenValue.toString());
        return filterChain;
    }

    protected String createContextToken(WAR deployable) {
        StringBuffer contextTokenValue = new StringBuffer();
        contextTokenValue.append("<Context path=\"");
        contextTokenValue.append("/" + deployable.getContext());
        contextTokenValue.append("\" docBase=\"");
        contextTokenValue.append(deployable.getFile().getAbsolutePath());
        contextTokenValue.append("\" debug=\"");
        contextTokenValue.append(this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        contextTokenValue.append("\"/>");
        return contextTokenValue.toString();
    }

    public String toString() {
        return "Catalina Standalone Configuration";
    }
}

