/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.spi.deployer.AbstractRemoteDeployer;
import org.codehaus.cargo.container.spi.deployer.DeployerWatchdog;
import org.codehaus.cargo.container.tomcat.internal.TomcatManager;
import org.codehaus.cargo.container.tomcat.internal.TomcatManagerException;

public abstract class AbstractTomcatDeployer
extends AbstractRemoteDeployer {
    private static final String NAME = "Cargo";
    private static final String VERSION = "0.7";
    private TomcatManager manager;

    public AbstractTomcatDeployer(Container container) {
        this.setMonitor(container.getMonitor());
    }

    public void deploy(Deployable deployable, DeployableMonitor monitor) {
        this.deploy(deployable);
        DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
        watchdog.setMonitor(this.getMonitor());
        watchdog.watchForAvailability();
    }

    public void deploy(Deployable deployable) {
        File file = deployable.getFile();
        this.getMonitor().info("Deploying [" + file + "]", ((Object)((Object)this)).getClass().getName());
        try {
            this.manager.deploy(this.getPath(deployable), new FileInputStream(file));
        }
        catch (TomcatManagerException exception) {
            throw new ContainerException("Failed to deploy [" + file + "]", (Throwable)exception);
        }
        catch (IOException exception) {
            throw new ContainerException("Failed to deploy [" + file + "]", (Throwable)exception);
        }
    }

    public void undeploy(Deployable deployable) {
        File file = deployable.getFile();
        this.getMonitor().info("Undeploying [" + file + "]", ((Object)((Object)this)).getClass().getName());
        try {
            this.manager.undeploy(this.getPath(deployable));
        }
        catch (TomcatManagerException exception) {
            throw new ContainerException("Failed to undeploy [" + file + "]", (Throwable)exception);
        }
        catch (IOException exception) {
            throw new ContainerException("Failed to undeploy [" + file + "]", (Throwable)exception);
        }
    }

    public void redeploy(Deployable deployable) {
        File file = deployable.getFile();
        this.getMonitor().info("Redeploying [" + file + "]", ((Object)((Object)this)).getClass().getName());
        try {
            this.manager.reload(this.getPath(deployable));
        }
        catch (TomcatManagerException exception) {
            throw new ContainerException("Failed to redeploy [" + file + "]", (Throwable)exception);
        }
        catch (IOException exception) {
            throw new ContainerException("Failed to redeploy [" + file + "]", (Throwable)exception);
        }
    }

    public void start(Deployable deployable) {
        File file = deployable.getFile();
        this.getMonitor().info("Starting [" + file + "]", ((Object)((Object)this)).getClass().getName());
        try {
            this.manager.start(this.getPath(deployable));
        }
        catch (TomcatManagerException exception) {
            throw new ContainerException("Failed to start [" + file + "]", (Throwable)exception);
        }
        catch (IOException exception) {
            throw new ContainerException("Failed to start [" + file + "]", (Throwable)exception);
        }
    }

    public void stop(Deployable deployable) {
        File file = deployable.getFile();
        this.getMonitor().info("Stopping [" + file + "]", ((Object)((Object)this)).getClass().getName());
        try {
            this.manager.stop(this.getPath(deployable));
        }
        catch (TomcatManagerException exception) {
            throw new ContainerException("Failed to stop [" + file + "]", (Throwable)exception);
        }
        catch (IOException exception) {
            throw new ContainerException("Failed to stop [" + file + "]", (Throwable)exception);
        }
    }

    protected void setTomcatManager(TomcatManager manager) {
        this.manager = manager;
    }

    protected TomcatManager createManager(Configuration configuration) {
        String managerURL = configuration.getPropertyValue("cargo.tomcat.manager.url");
        if (managerURL == null) {
            managerURL = configuration.getPropertyValue("cargo.protocol") + "://" + configuration.getPropertyValue("cargo.hostname") + ":" + configuration.getPropertyValue("cargo.servlet.port") + "/manager";
        }
        String username = configuration.getPropertyValue("cargo.tomcat.manager.username");
        String password = configuration.getPropertyValue("cargo.tomcat.manager.password");
        try {
            URL url = new URL(managerURL);
            TomcatManager manager = new TomcatManager(url, username, password);
            manager.setUserAgent("Cargo/0.7");
            return manager;
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create Tomcat Manager at URL [" + managerURL + "]", (Throwable)e);
        }
    }

    private String getPath(Deployable deployable) {
        if (deployable.getType() != DeployableType.WAR) {
            throw new ContainerException("Only WAR archives are supported for deployment in Tomcat. Got [" + deployable.getFile() + "]");
        }
        return "/" + ((WAR)deployable).getContext();
    }
}

