/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.builder.ConfigurationBuilder;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.tomcat.internal.AbstractCatalinaStandaloneLocalConfiguration;
import org.codehaus.cargo.container.tomcat.internal.Tomcat4xConfigurationBuilder;
import org.codehaus.cargo.container.tomcat.internal.Tomcat4xStandaloneLocalConfigurationCapability;

public class Tomcat4xStandaloneLocalConfiguration
extends AbstractCatalinaStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new Tomcat4xStandaloneLocalConfigurationCapability();

    public Tomcat4xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected ConfigurationBuilder createConfigurationBuilder(LocalContainer container) {
        return new Tomcat4xConfigurationBuilder();
    }

    @Override
    protected void setupManager(LocalContainer container) {
        String from = ((InstalledLocalContainer)container).getHome();
        String to = this.getHome();
        this.getFileHandler().copyDirectory(from + "/server/webapps/manager", to + "/server/webapps/manager");
        this.getFileHandler().copyFile(from + "/webapps/manager.xml", to + "/webapps/manager.xml");
    }

    protected String getXpathForResourcesParent() {
        return "//Engine/DefaultContext";
    }

    @Override
    public String toString() {
        return "Tomcat 4.x Standalone Configuration";
    }

    protected String getOrCreateResourceConfigurationFile(Resource rs, LocalContainer container) {
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        return this.getFileHandler().append(confDir, "server.xml");
    }

    @Override
    protected void doConfigure(LocalContainer container) throws Exception {
        InstalledLocalContainer installedContainer;
        String[] classPath;
        if (container instanceof InstalledLocalContainer && (classPath = (installedContainer = (InstalledLocalContainer)container).getExtraClasspath()) != null) {
            String commonLib = this.getFileHandler().append(installedContainer.getHome(), "common/lib");
            for (String path : classPath) {
                String target = this.getFileHandler().append(commonLib, this.getFileHandler().getName(path));
                this.getLogger().debug("Copying extra classpath JAR to " + target, ((Object)((Object)this)).getClass().getName());
                this.getFileHandler().copyFile(path, target);
            }
        }
        super.doConfigure(container);
        String serverXml = this.getFileHandler().append(this.getHome() + "/conf", "server.xml");
        Map replacements = this.getReplacements();
        replacements.put("catalina.logging.level", this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        replacements.put("tomcat.webapps", this.createTomcatWebappsToken());
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/" + container.getId() + "/server.xml", serverXml, this.getFileHandler(), replacements, StandardCharsets.UTF_8);
    }

    @Override
    protected void setupConfFiles(String confDir) {
    }
}

