/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.internal.util.PropertyUtils;
import org.codehaus.cargo.container.tomcat.Tomcat6xStandaloneLocalConfiguration;
import org.codehaus.cargo.container.tomcat.internal.Tomcat7xStandaloneLocalConfigurationCapability;

public class Tomcat7xStandaloneLocalConfiguration
extends Tomcat6xStandaloneLocalConfiguration {
    private static final String CONTEXT_ALLOWMULTIPART_ATTR_NAME = "allowCasualMultipartParsing";
    private static final String CONTEXT_ALLOWWEBJARS_ATTR_NAME = "addWebinfClassesResources";
    private static ConfigurationCapability capability = new Tomcat7xStandaloneLocalConfigurationCapability();

    public Tomcat7xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.servlet.users", "admin::manager-script");
        this.setProperty("cargo.tomcat.context.allowCasualMultipartParsing", "true");
        this.setProperty("cargo.tomcat.context.addWebinfClassesResources", "true");
        this.getProperties().remove("cargo.tomcat.connector.emptySessionPath");
    }

    @Override
    protected void doConfigure(LocalContainer container) throws Exception {
        super.doConfigure(container);
        this.getFileHandler().createDirectory(this.getHome(), "common/lib");
    }

    @Override
    public ConfigurationCapability getCapability() {
        return capability;
    }

    @Override
    protected void setupConfFiles(String confDir) {
        Map<String, String> replacements = this.getCatalinaPropertertiesReplacements();
        this.getFileHandler().replaceInFile(this.getFileHandler().append(confDir, "catalina.properties"), replacements, StandardCharsets.UTF_8);
        replacements.clear();
        replacements.put("</Host>", this.createTomcatWebappsToken() + "\n      </Host>");
        this.getFileHandler().replaceInFile(this.getFileHandler().append(confDir, "server.xml"), replacements, StandardCharsets.UTF_8);
        for (Map.Entry property : this.getProperties().entrySet()) {
            String propertyName = (String)property.getKey();
            if (!propertyName.startsWith("cargo.tomcat.valve")) continue;
            StringBuilder replacement = new StringBuilder("  <Valve ");
            String customValve = (String)property.getValue();
            Properties valveProps = PropertyUtils.splitPropertiesOnPipe((String)customValve);
            for (Map.Entry<Object, Object> valveEntry : valveProps.entrySet()) {
                String key = valveEntry.getKey().toString();
                String value = valveEntry.getValue().toString();
                replacement.append(key);
                replacement.append("=\"");
                replacement.append(value);
                replacement.append("\" ");
            }
            replacement.append("/>\n      </Host>");
            replacements.clear();
            replacements.put("</Host>", replacement.toString());
            this.getFileHandler().replaceInFile(this.getFileHandler().append(confDir, "server.xml"), replacements, StandardCharsets.UTF_8);
        }
    }

    @Override
    protected String getExtraContextAttributes() {
        return " " + CONTEXT_ALLOWMULTIPART_ATTR_NAME + "=\"" + this.getPropertyValue("cargo.tomcat.context.allowCasualMultipartParsing") + "\" " + CONTEXT_ALLOWWEBJARS_ATTR_NAME + "=\"" + this.getPropertyValue("cargo.tomcat.context.addWebinfClassesResources") + "\"";
    }

    @Override
    protected void performXmlReplacements(LocalContainer container) {
        String serverXmlFileName = "conf/server.xml";
        this.removeXmlReplacement(serverXmlFileName, this.connectorXpath(), "emptySessionPath");
        String startStopThreads = this.getPropertyValue("cargo.tomcat.host.startStopThreads");
        if (startStopThreads != null) {
            this.addXmlReplacement(serverXmlFileName, "//Server/Service/Engine/Host", "startStopThreads", startStopThreads);
        }
        this.addXmlReplacement(serverXmlFileName, "//Server/Service/Engine/Host/Valve[@className='org.apache.catalina.valves.AccessLogValve']", "prefix", this.getPropertyValue("cargo.hostname") + "_access_log.");
        super.performXmlReplacements(container);
    }

    @Override
    public String toString() {
        return "Tomcat 7.x Standalone Configuration";
    }
}

