/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.tomcat.internal.AbstractCatalinaEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.internal.TomcatEmbedded;

public class Tomcat8xEmbeddedLocalContainer
extends AbstractCatalinaEmbeddedLocalContainer {
    private static ClassLoader classLoader;

    public Tomcat8xEmbeddedLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public String getId() {
        return "tomcat8x";
    }

    public String getName() {
        return "Tomcat 8.x Embedded";
    }

    @Override
    protected void prepareController(TomcatEmbedded wrapper, File home, int port) {
        this.controller.enableNaming();
        TomcatEmbedded.Engine engine = this.controller.getEngine();
        engine.setParentClassLoader(this.getClassLoader());
        TomcatEmbedded.MemoryRealm realm = wrapper.new TomcatEmbedded.MemoryRealm();
        realm.setPathname(new File(home, "conf/tomcat-users.xml"));
        engine.setRealm(realm);
        this.controller.setPort(port);
        this.connector = this.controller.getConnector();
        this.host = this.controller.getHost();
        this.host.setAutoDeploy(false);
    }

    @Override
    protected void doStop() throws Exception {
        TomcatEmbedded.Context[] contexts = null;
        if (this.host != null) {
            contexts = this.host.findChildren();
        }
        super.doStop();
        if (contexts != null) {
            for (TomcatEmbedded.Context context : contexts) {
                context.destroy();
            }
        }
    }

    public ClassLoader getClassLoader() {
        if (classLoader == null) {
            classLoader = super.getClassLoader();
        }
        return classLoader;
    }
}

