/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.module.webapp.tomcat.TomcatWarArchive;

public class TomcatWAR
extends WAR {
    private TomcatWarArchive warArchive;

    public TomcatWAR(String war) {
        super(war);
        try {
            this.warArchive = new TomcatWarArchive(this.getFile());
        }
        catch (Exception e) {
            throw new ContainerException("Failed to parse Tomcat WAR file in [" + this.getFile() + "]", (Throwable)e);
        }
    }

    public synchronized String getContext() {
        String result = this.parseTomcatContextXml();
        if (result == null) {
            result = super.getContext();
        }
        return result;
    }

    public String parseTomcatContextXml() {
        String context = null;
        if (this.warArchive.getTomcatContextXml() != null && (context = this.warArchive.getTomcatContextXml().getPath()) != null) {
            context = context.trim();
            while (context.contains("//")) {
                context = context.replace("//", "/");
            }
            while (context.startsWith("/")) {
                context = context.substring(1);
            }
            while (context.endsWith("/")) {
                context = context.substring(0, context.length() - 1);
            }
        }
        return context;
    }

    public boolean containsContextFile() {
        return this.warArchive.getTomcatContextXml() != null;
    }
}

