/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import java.io.FileNotFoundException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;
import org.codehaus.cargo.container.tomcat.internal.AbstractCatalinaInstalledLocalContainer;

public class Tomcat4xInstalledLocalContainer
extends AbstractCatalinaInstalledLocalContainer {
    public static final String ID = "tomcat4x";

    public Tomcat4xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return "Tomcat " + this.getVersion("4.x");
    }

    @Override
    public void doStart(JvmLauncher java) throws Exception {
        File commonLibDirectory = new File(this.getHome(), "common/lib");
        if (!commonLibDirectory.isDirectory()) {
            throw new FileNotFoundException("directory " + commonLibDirectory + " does not exist");
        }
        java.addClasspathEntries(commonLibDirectory.listFiles());
        super.doStart(java);
    }

    @Override
    protected void invokeContainer(String action, JvmLauncher java) throws Exception {
        String base = this.getFileHandler().getAbsolutePath(this.getConfiguration().getHome());
        java.setSystemProperty("catalina.home", this.getFileHandler().getAbsolutePath(this.getHome()));
        java.setSystemProperty("catalina.base", base);
        java.setSystemProperty("java.io.tmpdir", this.getFileHandler().append(base, "temp"));
        java.addClasspathEntries(new File[]{new File(this.getHome(), "bin/bootstrap.jar")});
        this.addToolsJarToClasspath(java);
        java.setMainClass("org.apache.catalina.startup.Bootstrap");
        java.addAppArguments(new String[]{action});
        java.start();
    }
}

