/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.builder.ConfigurationBuilder;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.internal.util.PropertyUtils;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.container.tomcat.internal.AbstractCatalinaStandaloneLocalConfiguration;
import org.codehaus.cargo.container.tomcat.internal.Tomcat5x6x7xConfigurationBuilder;
import org.codehaus.cargo.container.tomcat.internal.Tomcat5xStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.util.XmlReplacement;
import org.w3c.dom.Element;

public class Tomcat5xStandaloneLocalConfiguration
extends AbstractCatalinaStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new Tomcat5xStandaloneLocalConfigurationCapability();
    protected Tomcat5x6x7xConfigurationBuilder configurationBuilder;

    public Tomcat5xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.tomcat.connector.emptySessionPath", "true");
        this.setProperty("cargo.tomcat.httpSecure", "false");
        this.configurationBuilder = new Tomcat5x6x7xConfigurationBuilder();
        this.addXmlReplacements();
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected ConfigurationBuilder createConfigurationBuilder(LocalContainer container) {
        return this.configurationBuilder;
    }

    @Override
    protected void setupManager(LocalContainer container) {
        if (!(container instanceof EmbeddedLocalContainer)) {
            String from = ((InstalledLocalContainer)container).getHome();
            String to = this.getHome();
            this.getFileHandler().copyDirectory(from + "/server/webapps/manager", to + "/server/webapps/manager");
            this.getFileHandler().copyFile(from + "/conf/Catalina/localhost/manager.xml", to + "/conf/Catalina/localhost/manager.xml");
        }
    }

    protected void performXmlReplacements(LocalContainer container) {
        this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "port", "cargo.servlet.port");
        this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "scheme", "cargo.protocol");
        this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "secure", "cargo.tomcat.httpSecure");
        this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "emptySessionPath", "cargo.tomcat.connector.emptySessionPath");
        this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "URIEncoding", "cargo.tomcat.uriencoding");
        this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "port", "cargo.servlet.port");
        if (!(container instanceof EmbeddedLocalContainer)) {
            this.setProperty("cargo.tomcat.httpSecure", String.valueOf("https".equalsIgnoreCase(container.getConfiguration().getPropertyValue("cargo.protocol"))));
            this.addOptionalXmlReplacements(container);
            super.performXmlReplacements(container);
        }
    }

    @Override
    public String toString() {
        return "Tomcat 5.x Standalone Configuration";
    }

    @Override
    protected void setupTransactionManager() {
        Resource transactionManagerResource = new Resource("UserTransaction", "javax.transaction.UserTransaction");
        Properties parameters = new Properties();
        PropertyUtils.setPropertyIfNotNull((Properties)parameters, (String)"jotm.timeout", (Object)"60");
        PropertyUtils.setPropertyIfNotNull((Properties)parameters, (String)"factory", (Object)"org.objectweb.jotm.UserTransactionFactory");
        transactionManagerResource.setParameters(PropertyUtils.toMap((Properties)parameters));
        this.getResources().add(transactionManagerResource);
    }

    protected String getXpathForResourcesParent() {
        return "//Context";
    }

    protected String getOrCreateResourceConfigurationFile(Resource rs, LocalContainer container) {
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        return this.getFileHandler().append(confDir, "context.xml");
    }

    @Override
    protected String getTomcatLoggingLevel(String cargoLoggingLevel) {
        String level = LoggingLevel.LOW.equalsLevel(cargoLoggingLevel) ? "WARNING" : (LoggingLevel.MEDIUM.equalsLevel(cargoLoggingLevel) ? "INFO" : "FINE");
        return level;
    }

    @Override
    protected String createContextToken(WAR deployable) {
        StringBuilder contextTokenValue = new StringBuilder();
        contextTokenValue.append("<Context");
        contextTokenValue.append(" path=\"");
        if (!"".equals(deployable.getContext()) && !"/".equals(deployable.getContext())) {
            contextTokenValue.append("/" + deployable.getContext());
        }
        contextTokenValue.append("\"");
        contextTokenValue.append(" docBase=\"");
        contextTokenValue.append(new File(deployable.getFile()).getAbsolutePath());
        contextTokenValue.append("\"");
        contextTokenValue.append(" reloadable=\"");
        contextTokenValue.append(this.getPropertyValue("cargo.tomcat.context.reloadable"));
        contextTokenValue.append("\"");
        contextTokenValue.append(this.getExtraContextAttributes());
        contextTokenValue.append(">");
        contextTokenValue.append(this.getExtraClasspathToken(deployable));
        contextTokenValue.append("</Context>");
        return contextTokenValue.toString();
    }

    protected String getExtraContextAttributes() {
        return "";
    }

    @Override
    protected void setupConfFiles(String confDir) {
        Map<String, String> replacements = this.getCatalinaPropertertiesReplacements();
        this.getFileHandler().replaceInFile(this.getFileHandler().append(confDir, "catalina.properties"), replacements, StandardCharsets.UTF_8);
        replacements.clear();
        replacements.put("</Host>", this.createTomcatWebappsToken() + "\n        <Valve className=\"org.apache.catalina.valves.AccessLogValve\" \n               directory=\"logs\" prefix=\"" + this.getPropertyValue("cargo.hostname") + "_access_log.\" \n               suffix=\".txt\"\n               pattern=\"%h %l %u %t &quot;%r&quot; %s %b\"\n               resolveHosts=\"false\"/>\n      </Host>");
        this.getFileHandler().replaceInFile(this.getFileHandler().append(confDir, "server.xml"), replacements, StandardCharsets.UTF_8);
    }

    protected Map<String, String> getCatalinaPropertertiesReplacements() {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("common.loader=", "common.loader=${catalina.base}/common/classes,${catalina.base}/common/lib/*.jar,");
        replacements.put("server.loader=", "server.loader=${catalina.base}/server/classes,${catalina.base}/server/lib/*.jar,");
        return replacements;
    }

    protected String getExtraClasspathToken(WAR deployable) {
        this.getLogger().warn("Tomcat 5.x doesn't support extra classpath on WARs", ((Object)((Object)this)).getClass().getName());
        return "";
    }

    protected void configureExtraClasspathToken(WAR deployable, Element context) {
        this.getLogger().warn("Tomcat 5.x doesn't support extra classpath on WARs", ((Object)((Object)this)).getClass().getName());
    }

    private void addXmlReplacements() {
        this.addXmlReplacement("conf/server.xml", "//Server", "port", "cargo.rmi.port");
        this.addXmlReplacement("conf/server.xml", "//Server/Service/Connector[@protocol='AJP/1.3']", "port", "cargo.tomcat.ajp.port", XmlReplacement.ReplacementBehavior.IGNORE_IF_NON_EXISTING);
        this.addXmlReplacement("conf/server.xml", "//Server/Service/Engine", "defaultHost", "cargo.hostname");
        this.addXmlReplacement("conf/server.xml", "//Server/Service/Engine/Host", "name", "cargo.hostname");
        this.addXmlReplacement("conf/server.xml", "//Server/Service/Engine/Host", "appBase", "cargo.tomcat.webappsDirectory");
    }

    private void addOptionalXmlReplacements(LocalContainer container) {
        if (!"localhost".equals(container.getConfiguration().getPropertyValue("cargo.hostname"))) {
            this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "address", "cargo.hostname");
            this.addXmlReplacement("conf/server.xml", "//Server/Service/Connector[@protocol='AJP/1.3']", "address", "cargo.hostname", XmlReplacement.ReplacementBehavior.IGNORE_IF_NON_EXISTING);
        }
        if (container.getConfiguration().getPropertyValue("cargo.tomcat.useHttpOnly") != null) {
            this.addXmlReplacement("conf/context.xml", "//Context", "useHttpOnly", "cargo.tomcat.useHttpOnly");
        }
        if (container.getConfiguration().getPropertyValue("cargo.tomcat.connector.keystoreFile") != null) {
            this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "keystoreFile", "cargo.tomcat.connector.keystoreFile");
        }
        if (container.getConfiguration().getPropertyValue("cargo.tomcat.connector.keystorePass") != null) {
            this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "keystorePass", "cargo.tomcat.connector.keystorePass");
        }
        if (container.getConfiguration().getPropertyValue("cargo.tomcat.connector.keystoreType") != null) {
            this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "keystoreType", "cargo.tomcat.connector.keystoreType");
        }
        if (container.getConfiguration().getPropertyValue("cargo.tomcat.connector.keyAlias") != null) {
            this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "keyAlias", "cargo.tomcat.connector.keyAlias");
        }
        if (container.getConfiguration().getPropertyValue("cargo.tomcat.connector.clientAuth") != null) {
            this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "clientAuth", "cargo.tomcat.connector.clientAuth");
        }
        if (container.getConfiguration().getPropertyValue("cargo.tomcat.connector.truststoreFile") != null) {
            this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "truststoreFile", "cargo.tomcat.connector.truststoreFile");
        }
        if (container.getConfiguration().getPropertyValue("cargo.tomcat.connector.truststorePass") != null) {
            this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "truststorePass", "cargo.tomcat.connector.truststorePass");
        }
        if (container.getConfiguration().getPropertyValue("cargo.tomcat.connector.truststoreType") != null) {
            this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "truststoreType", "cargo.tomcat.connector.truststoreType");
        }
        if (container.getConfiguration().getPropertyValue("cargo.tomcat.connector.sslProtocol") != null) {
            this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "sslProtocol", "cargo.tomcat.connector.sslProtocol");
        }
        if (container.getConfiguration().getPropertyValue("cargo.tomcat.connector.maxHttpHeaderSize") != null) {
            this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "maxHttpHeaderSize", "cargo.tomcat.connector.maxHttpHeaderSize");
        }
    }
}

