/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.tomcat.Tomcat5xStandaloneLocalConfiguration;
import org.codehaus.cargo.container.tomcat.internal.TomcatUtils;
import org.codehaus.cargo.util.CargoException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Tomcat6xStandaloneLocalConfiguration
extends Tomcat5xStandaloneLocalConfiguration {
    public Tomcat6xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    @Override
    protected void doConfigure(LocalContainer container) throws Exception {
        super.doConfigure(container);
        this.getFileHandler().createDirectory(this.getHome(), "common/classes");
        this.getFileHandler().createDirectory(this.getHome(), "shared/classes");
        this.getFileHandler().createDirectory(this.getHome(), "shared/lib");
    }

    @Override
    protected void setupManager(LocalContainer container) {
        if (!(container instanceof EmbeddedLocalContainer)) {
            String from = ((InstalledLocalContainer)container).getHome();
            String to = this.getHome();
            this.getFileHandler().copyDirectory(from + "/webapps/manager", to + "/webapps/manager");
            this.getFileHandler().copyDirectory(from + "/webapps/host-manager", to + "/webapps/host-manager");
        }
    }

    @Override
    protected Map<String, String> getCatalinaPropertertiesReplacements() {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("common.loader=", "common.loader=${catalina.base}/common/classes,${catalina.base}/common/lib/*.jar,");
        replacements.put("shared.loader=", "shared.loader=${catalina.base}/shared/classes,${catalina.base}/shared/lib/*.jar,");
        return replacements;
    }

    @Override
    protected String getExtraClasspathToken(WAR deployable) {
        String extraClasspath = TomcatUtils.getExtraClasspath(deployable, true);
        if (extraClasspath != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<Loader");
            sb.append(" className=\"org.apache.catalina.loader.VirtualWebappLoader\"");
            sb.append(" virtualClasspath=\"" + extraClasspath + "\"");
            sb.append("/>");
            return sb.toString();
        }
        return "";
    }

    @Override
    protected void configureExtraClasspathToken(WAR deployable, Element context) {
        String extraClasspath = TomcatUtils.getExtraClasspath(deployable, true);
        if (extraClasspath != null) {
            Element loader;
            NodeList loaderList = context.getElementsByTagName("Loader");
            if (loaderList.getLength() > 0) {
                loader = (Element)loaderList.item(0);
            } else {
                loader = context.getOwnerDocument().createElement("Loader");
                context.appendChild(loader);
            }
            String className = loader.getAttribute("className");
            if (!(className == null || className.isEmpty() || "org.apache.catalina.loader.WebappLoader".equals(className) || "org.apache.catalina.loader.VirtualWebappLoader".equals(className))) {
                throw new CargoException("Extra classpath is not supported for WARs using custom loader: " + className);
            }
            loader.setAttribute("className", "org.apache.catalina.loader.VirtualWebappLoader");
            String virtualClasspath = loader.getAttribute("virtualClasspath");
            virtualClasspath = virtualClasspath == null || virtualClasspath.isEmpty() ? extraClasspath : extraClasspath + ";" + virtualClasspath;
            loader.setAttribute("virtualClasspath", virtualClasspath);
        }
    }

    @Override
    protected void performXmlReplacements(LocalContainer container) {
        this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "SSLEnabled", "cargo.tomcat.httpSecure");
        String connectorProtocolClass = this.getPropertyValue("cargo.tomcat.connector.protocolClass");
        if (connectorProtocolClass != null) {
            this.addXmlReplacement("conf/server.xml", this.connectorXpath(), "protocol", connectorProtocolClass);
        }
        super.performXmlReplacements(container);
    }

    @Override
    public String toString() {
        return "Tomcat 6.x Standalone Configuration";
    }
}

