/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractExistingLocalConfiguration;
import org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.TomcatCopyingInstalledLocalDeployer;
import org.codehaus.cargo.container.tomcat.TomcatEmbeddedLocalDeployer;
import org.codehaus.cargo.container.tomcat.internal.TomcatExistingLocalConfigurationCapability;
import org.codehaus.cargo.util.CargoException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TomcatExistingLocalConfiguration
extends AbstractExistingLocalConfiguration {
    private static ConfigurationCapability capability = new TomcatExistingLocalConfigurationCapability();

    public TomcatExistingLocalConfiguration(String dir) {
        super(dir);
        String file = this.getFileHandler().append(dir, "conf/server.xml");
        if (!this.getFileHandler().exists(file)) {
            this.getLogger().warn("Cannot find file " + file + ", setting default " + "cargo.tomcat.webappsDirectory", ((Object)((Object)this)).getClass().getName());
            this.setProperty("cargo.tomcat.webappsDirectory", "webapps");
            return;
        }
        try {
            Document doc;
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            if (this.getFileHandler().isDirectory(file)) {
                throw new CargoException("The destination is a directory: " + file);
            }
            try (InputStream is = this.getFileHandler().getInputStream(file);){
                doc = builder.parse(is);
            }
            String expression = "//Server/Service/Engine/Host";
            String attributeName = "appBase";
            XPathExpression xPathExpr = xPath.compile(expression);
            Node node = (Node)xPathExpr.evaluate(doc, XPathConstants.NODE);
            if (node == null) {
                throw new CargoException("Node " + expression + " not found in file " + file);
            }
            Node attribute = node.getAttributes().getNamedItem(attributeName);
            if (attribute == null) {
                throw new CargoException("Attribute " + attribute + " not found on node " + expression + " in file " + file);
            }
            this.setProperty("cargo.tomcat.webappsDirectory", attribute.getNodeValue());
        }
        catch (Exception e) {
            throw new CargoException("Cannot read the Tomcat server.xml file", (Throwable)e);
        }
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        if (container instanceof Tomcat5xEmbeddedLocalContainer) {
            TomcatEmbeddedLocalDeployer deployer = new TomcatEmbeddedLocalDeployer((EmbeddedLocalContainer)((Tomcat5xEmbeddedLocalContainer)container));
            deployer.redeploy(this.getDeployables());
        } else {
            File webappsDir = new File(this.getHome(), this.getPropertyValue("cargo.tomcat.webappsDirectory"));
            if (!webappsDir.exists()) {
                throw new ContainerException("Invalid existing configuration: The [" + webappsDir.getPath() + "] directory does not exist");
            }
            TomcatCopyingInstalledLocalDeployer deployer = this.createDeployer(container);
            deployer.setShouldCopyWars(true);
            deployer.redeploy(this.getDeployables());
            this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(webappsDir, "cargocpc.war"));
        }
    }

    public void verify() {
    }

    public String toString() {
        return "Tomcat Existing Configuration";
    }

    protected TomcatCopyingInstalledLocalDeployer createDeployer(LocalContainer container) {
        return new TomcatCopyingInstalledLocalDeployer(container);
    }
}

