/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.internal.ServletContainerCapability;
import org.codehaus.cargo.container.spi.AbstractEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.TomcatEmbeddedLocalDeployer;
import org.codehaus.cargo.container.tomcat.internal.TomcatEmbedded;
import org.codehaus.cargo.util.CargoException;

public abstract class AbstractCatalinaEmbeddedLocalContainer
extends AbstractEmbeddedLocalContainer {
    protected TomcatEmbedded.Embedded controller;
    protected TomcatEmbedded.Host host;
    protected TomcatEmbedded.Connector connector;
    private String previousCatalinaBase;
    private final ContainerCapability capability = new ServletContainerCapability();
    private final Map<String, WAR> scheduledDeployables = new HashMap<String, WAR>();

    public AbstractCatalinaEmbeddedLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public TomcatEmbedded.Embedded getController() {
        return this.controller;
    }

    public TomcatEmbedded.Host getHost() {
        return this.host;
    }

    protected void doStart() throws Exception {
        File home = new File(this.getConfiguration().getHome()).getAbsoluteFile();
        this.previousCatalinaBase = System.setProperty("catalina.base", home.getAbsolutePath());
        try {
            TomcatEmbedded wrapper = new TomcatEmbedded(this.getClassLoader());
            this.controller = new TomcatEmbedded.Embedded(wrapper);
            this.controller.setCatalinaBase(home);
            this.prepareController(wrapper, home, Integer.parseInt(this.getConfiguration().getPropertyValue("cargo.servlet.port")));
            if (this.connector == null || this.host == null) {
                throw new CargoException("Programming error: attributes connector or host not set after prepareController");
            }
            this.controller.start();
            File[] webapps = new File(this.getConfiguration().getHome(), this.getConfiguration().getPropertyValue("cargo.tomcat.webappsDirectory")).listFiles();
            if (webapps != null) {
                for (File webapp : webapps) {
                    WAR war;
                    if (webapp.isFile()) {
                        String webappName = webapp.getAbsolutePath();
                        if (new File(webappName = webappName.substring(0, webappName.length() - 4)).isDirectory()) continue;
                    }
                    if (this.scheduledDeployables.containsKey((war = new WAR(webapp.getAbsolutePath())).getContext())) continue;
                    this.scheduledDeployables.put(war.getContext(), war);
                }
            }
            if (!this.scheduledDeployables.isEmpty()) {
                TomcatEmbeddedLocalDeployer deployer = new TomcatEmbeddedLocalDeployer((EmbeddedLocalContainer)this);
                HashMap<String, WAR> scheduledDeployablesCopy = new HashMap<String, WAR>(this.scheduledDeployables);
                for (Map.Entry deployable : scheduledDeployablesCopy.entrySet()) {
                    deployer.redeploy((Deployable)deployable.getValue());
                    this.scheduledDeployables.remove(deployable.getKey());
                }
            }
        }
        catch (Exception e) {
            if (this.previousCatalinaBase == null) {
                System.clearProperty("catalina.base");
            } else {
                System.setProperty("catalina.base", this.previousCatalinaBase);
            }
            throw e;
        }
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
        if (!waitForStarting) {
            super.waitForCompletion(waitForStarting);
        }
    }

    protected void doStop() throws Exception {
        if (this.controller != null) {
            try {
                this.controller.stop();
                this.connector.destroy();
                this.controller = null;
                this.connector = null;
                this.host = null;
            }
            finally {
                if (this.previousCatalinaBase == null) {
                    System.clearProperty("catalina.base");
                } else {
                    System.setProperty("catalina.base", this.previousCatalinaBase);
                }
            }
        } else {
            throw new ContainerException("Embedded Tomcat container is not started");
        }
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    public void scheduleDeployment(Deployable deployable) {
        WAR war = (WAR)deployable;
        this.scheduledDeployables.put(war.getContext(), war);
    }

    protected abstract void prepareController(TomcatEmbedded var1, File var2, int var3);
}

