/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.codehaus.cargo.container.tomcat.internal.NonceCounter;
import org.codehaus.cargo.container.tomcat.internal.TomcatDeployableStatus;
import org.codehaus.cargo.container.tomcat.internal.TomcatManagerException;
import org.codehaus.cargo.util.log.LoggedObject;

public class TomcatManager
extends LoggedObject {
    private static final NonceCounter NONCE_COUNTER = new NonceCounter();
    private static final int BUFFER_CHUNK_SIZE = 262144;
    private URL url;
    private String username;
    private String password;
    private String charset;
    private String userAgent;
    private int timeout = 0;

    public TomcatManager(URL url, String username, String password) {
        this(url, username, password, StandardCharsets.UTF_8);
    }

    public TomcatManager(URL url, String username, String password, Charset charset) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.charset = charset.name();
    }

    public URL getURL() {
        return this.url;
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Charset getCharset() {
        return Charset.forName(this.charset);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void deploy(String path, URL war) throws TomcatManagerException, IOException {
        this.deploy(path, war, false);
    }

    public void deploy(String path, URL war, boolean update) throws TomcatManagerException, IOException {
        this.deploy(path, war, update, null);
    }

    public void deploy(String path, URL war, boolean update, String tag) throws TomcatManagerException, IOException {
        this.deployImpl(path, null, null, war, null, update, tag);
    }

    public void deploy(String path, File war) throws TomcatManagerException, IOException {
        this.deploy(path, war, false);
    }

    public void deploy(String path, File war, boolean update) throws TomcatManagerException, IOException {
        this.deploy(path, war, update, null);
    }

    public void deploy(String path, File war, boolean update, String tag) throws TomcatManagerException, IOException {
        this.deployImpl(path, null, null, null, war, update, tag);
    }

    public void deploy(String path, String version, File war, boolean update, String tag) throws TomcatManagerException, IOException {
        this.deployImpl(path, version, null, null, war, update, tag);
    }

    public void deployContext(String path, URL config) throws TomcatManagerException, IOException {
        this.deployContext(path, config, false);
    }

    public void deployContext(String path, URL config, boolean update) throws TomcatManagerException, IOException {
        this.deployContext(path, config, update, null);
    }

    public void deployContext(String path, URL config, boolean update, String tag) throws TomcatManagerException, IOException {
        this.deployContext(path, config, null, update, tag);
    }

    public void deployContext(String path, URL config, URL war) throws TomcatManagerException, IOException {
        this.deployContext(path, config, war, false);
    }

    public void deployContext(String path, URL config, URL war, boolean update) throws TomcatManagerException, IOException {
        this.deployContext(path, config, war, update, null);
    }

    public void deployContext(String path, URL config, URL war, boolean update, String tag) throws TomcatManagerException, IOException {
        this.deployImpl(path, null, config, war, null, update, tag);
    }

    public void undeploy(String path) throws TomcatManagerException, IOException {
        this.undeploy(path, null);
    }

    public void undeploy(String path, String version) throws TomcatManagerException, IOException {
        StringBuilder sb = new StringBuilder("/undeploy");
        sb.append("?path=").append(URLEncoder.encode(path, this.charset));
        if (version != null) {
            sb.append("&version=").append(URLEncoder.encode(version, this.charset));
        }
        this.invoke(sb.toString());
    }

    public void remove(String path) throws TomcatManagerException, IOException {
        this.invoke("/remove?path=" + URLEncoder.encode(path, this.charset));
    }

    public void reload(String path) throws TomcatManagerException, IOException {
        this.invoke("/reload?path=" + URLEncoder.encode(path, this.charset));
    }

    public void start(String path) throws TomcatManagerException, IOException {
        this.invoke("/start?path=" + URLEncoder.encode(path, this.charset));
    }

    public void stop(String path) throws TomcatManagerException, IOException {
        this.invoke("/stop?path=" + URLEncoder.encode(path, this.charset));
    }

    protected void invoke(String path) throws TomcatManagerException, IOException {
        this.invoke(path, null, null);
    }

    protected String invoke(String path, File fileData, String digestData) throws TomcatManagerException, IOException {
        String response;
        this.getLogger().debug("Invoking Tomcat manager using path [" + path + "]", ((Object)((Object)this)).getClass().getName());
        URL invokeURL = new URL(this.url + path);
        HttpURLConnection connection = (HttpURLConnection)invokeURL.openConnection();
        connection.setAllowUserInteraction(false);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        if (this.timeout > 0) {
            connection.setConnectTimeout(this.timeout);
            connection.setReadTimeout(this.timeout);
        }
        if (fileData == null) {
            this.getLogger().debug("Performing GET request", ((Object)((Object)this)).getClass().getName());
            connection.setDoOutput(false);
            connection.setRequestMethod("GET");
        } else {
            this.getLogger().debug("Performing PUT request", ((Object)((Object)this)).getClass().getName());
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", "application/octet-stream");
            connection.setChunkedStreamingMode(262144);
        }
        if (this.userAgent != null) {
            connection.setRequestProperty("User-Agent", this.userAgent);
        }
        if (digestData != null) {
            connection.setRequestProperty("Authorization", digestData);
        } else if (this.username != null && !this.username.isEmpty()) {
            String authorization = TomcatManager.toAuthorization(this.username, this.password);
            connection.setRequestProperty("Authorization", authorization);
        }
        connection.connect();
        try {
            if (fileData != null) {
                try (FileInputStream dataStream = new FileInputStream(fileData);
                     BufferedOutputStream bufferedOut = new BufferedOutputStream(connection.getOutputStream());){
                    int n;
                    byte[] bytes = new byte[262144];
                    while ((n = ((InputStream)dataStream).read(bytes)) != -1) {
                        bufferedOut.write(bytes, 0, n);
                    }
                    bufferedOut.flush();
                }
            }
            Charset charset = TomcatManager.extractCharset(connection.getContentType());
            response = this.toString(connection.getInputStream(), charset);
        }
        catch (IOException e) {
            switch (connection.getResponseCode()) {
                case 401: {
                    String wwwAuthenticate = connection.getHeaderField("WWW-Authenticate");
                    if (digestData == null && wwwAuthenticate != null && wwwAuthenticate.startsWith("Digest ")) {
                        MessageDigest digest;
                        this.getLogger().debug("Response code is 401 and server requests Digest authentication", ((Object)((Object)this)).getClass().getName());
                        String realm = TomcatManager.extractHeaderComponent(wwwAuthenticate, "realm");
                        String qop = TomcatManager.extractHeaderComponent(wwwAuthenticate, "qop");
                        String nonce = TomcatManager.extractHeaderComponent(wwwAuthenticate, "nonce");
                        String opaque = TomcatManager.extractHeaderComponent(wwwAuthenticate, "opaque");
                        String algorithm = TomcatManager.extractHeaderComponent(wwwAuthenticate, "algorithm");
                        if (realm == null || nonce == null) {
                            throw new TomcatManagerException("The username and password you provided are not correct (error 401), the server requested a Digest authentication but realm or nonce are not provided", e);
                        }
                        if (qop != null && !"auth".equals(qop)) {
                            throw new TomcatManagerException("The username and password you provided are not correct (error 401), the server requested a Digest authentication but qop is set to " + qop, e);
                        }
                        if (algorithm == null) {
                            algorithm = "MD5";
                        }
                        try {
                            digest = MessageDigest.getInstance(algorithm);
                        }
                        catch (NoSuchAlgorithmException nsae) {
                            throw new TomcatManagerException("The username and password you provided are not correct (error 401), the server requested a Digest authentication but algorithm is set to " + algorithm, nsae);
                        }
                        String ha1 = this.username + ":" + realm + ":" + this.password;
                        byte[] hash = digest.digest(ha1.getBytes(StandardCharsets.UTF_8));
                        StringBuilder sb = new StringBuilder();
                        for (byte hashByte : hash) {
                            sb.append(String.format("%02x", hashByte));
                        }
                        ha1 = sb.toString();
                        String uriPath = invokeURL.getPath();
                        String uriQuery = invokeURL.getQuery();
                        String uri = uriQuery != null ? uriPath + "?" + uriQuery : uriPath;
                        String ha2 = fileData == null ? "GET" : "PUT";
                        ha2 = ha2 + ":" + uri;
                        hash = digest.digest(ha2.getBytes(StandardCharsets.UTF_8));
                        sb = new StringBuilder();
                        for (byte hashByte : hash) {
                            sb.append(String.format("%02x", hashByte));
                        }
                        ha2 = sb.toString();
                        String nc = NONCE_COUNTER.count(nonce);
                        String cnonce = String.format("%08x", (long)(Math.random() * 4.294967295E9));
                        cnonce = cnonce.substring(cnonce.length() - 8);
                        String ha3 = qop != null ? ha1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + ha2 : ha1 + ":" + nonce + ":" + ha2;
                        hash = digest.digest(ha3.getBytes(StandardCharsets.UTF_8));
                        sb = new StringBuilder();
                        for (byte hashByte : hash) {
                            sb.append(String.format("%02x", hashByte));
                        }
                        ha3 = sb.toString();
                        wwwAuthenticate = "Digest username=\"" + this.username + "\", realm=\"" + realm + "\", nonce=\"" + nonce + "\", uri=\"" + uri + "\", algorithm=" + algorithm + ", nc=" + nc + ", cnonce=\"" + cnonce + "\", response=\"" + ha3 + "\"";
                        if (qop != null) {
                            wwwAuthenticate = wwwAuthenticate + ", qop=\"" + qop + "\"";
                        }
                        if (opaque != null) {
                            wwwAuthenticate = wwwAuthenticate + ", opaque=\"" + opaque + "\"";
                        }
                        this.getLogger().debug("Digest authentication with ha=" + ha1 + ", ha2=" + ha2 + " and full header " + wwwAuthenticate, ((Object)((Object)this)).getClass().getName());
                        return this.invoke(path, fileData, wwwAuthenticate);
                    }
                    throw new TomcatManagerException("The username and password you provided are not correct (error 401)", e);
                }
                case 403: {
                    throw new TomcatManagerException("The username you provided is not allowed to use the text-based Tomcat Manager (error 403)", e);
                }
            }
            throw e;
        }
        if (!response.startsWith("OK -")) {
            throw new TomcatManagerException("The Tomcat Manager responded \"" + response + "\" instead of the expected \"OK\" message");
        }
        return response;
    }

    private void deployImpl(String path, String version, URL config, URL war, File file, boolean update, String tag) throws TomcatManagerException, IOException {
        StringBuilder sb = new StringBuilder("/deploy");
        sb.append("?path=").append(URLEncoder.encode(path, this.charset));
        if (version != null) {
            sb.append("&version=").append(URLEncoder.encode(version, this.charset));
        }
        if (config != null) {
            sb.append("&config=").append(URLEncoder.encode(config.toString(), this.charset));
        }
        if (war != null) {
            sb.append("&war=").append(URLEncoder.encode(war.toString(), this.charset));
        }
        if (update) {
            sb.append("&update=true");
        }
        if (tag != null) {
            sb.append("&tag=").append(URLEncoder.encode(tag, this.charset));
        }
        this.invoke(sb.toString(), file, null);
    }

    protected static Charset extractCharset(String contentType) {
        int charsetStart;
        Charset charset = StandardCharsets.UTF_8;
        if (contentType != null && (charsetStart = contentType.indexOf("; charset=")) > 0) {
            try {
                charset = Charset.forName(contentType.substring(charsetStart + 10));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return charset;
    }

    protected static String extractHeaderComponent(String header, String component) {
        String fullComponent = component + "=\"";
        int fullComponentLength = fullComponent.length();
        int index1 = header.indexOf(fullComponent);
        if (index1 == -1) {
            return null;
        }
        int index2 = header.indexOf(34, index1 + fullComponentLength);
        if (index2 == -1) {
            return null;
        }
        return header.substring(index1 + fullComponentLength, index2);
    }

    private static String toAuthorization(String username, String password) {
        StringBuilder sb = new StringBuilder();
        sb.append(username).append(':');
        if (password != null) {
            sb.append(password);
        }
        return "Basic " + Base64.getEncoder().encodeToString(sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    private String toString(InputStream in, Charset charset) throws IOException {
        String splitResponse;
        int httpHeaderBodySeparation;
        int n;
        InputStreamReader reader = new InputStreamReader(in, charset);
        StringBuilder sb = new StringBuilder();
        char[] chars = new char[1024];
        while ((n = reader.read(chars, 0, chars.length)) != -1) {
            sb.append(chars, 0, n);
        }
        String response = sb.toString().replaceAll("\\r\\n?", "\n");
        if (response.startsWith("HTTP/") && (httpHeaderBodySeparation = response.indexOf("\n\n")) != -1 && (httpHeaderBodySeparation = (splitResponse = response.substring(httpHeaderBodySeparation + 2)).indexOf(10)) != -1) {
            response = splitResponse.substring(httpHeaderBodySeparation + 1);
        }
        return response;
    }

    public String list() throws IOException, TomcatManagerException {
        return this.invoke("/list", null, null);
    }

    public TomcatDeployableStatus getStatus(String path) throws IOException, TomcatManagerException {
        return this.getStatus(path, null);
    }

    public TomcatDeployableStatus getStatus(String path, String version) throws IOException, TomcatManagerException {
        String versionIdentifier = version != null ? "##" + version : null;
        StringTokenizer records = new StringTokenizer(this.list(), "\n");
        while (records.hasMoreTokens()) {
            String record = records.nextToken();
            StringTokenizer words = new StringTokenizer(record, ":");
            while (words.hasMoreTokens()) {
                String str = words.nextToken();
                if (!path.equals(str)) continue;
                String status = words.nextToken();
                if (versionIdentifier != null) {
                    str = words.nextToken();
                    try {
                        str = words.nextToken();
                        if (!str.endsWith(versionIdentifier)) continue;
                        return TomcatDeployableStatus.toStatus(status);
                    }
                    catch (NoSuchElementException ignored) {
                        return TomcatDeployableStatus.toStatus(status);
                    }
                }
                return TomcatDeployableStatus.toStatus(status);
            }
        }
        return TomcatDeployableStatus.NOT_FOUND;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

