/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.configuration.AbstractExistingLocalConfiguration;
import org.codehaus.cargo.container.weblogic.internal.WebLogicExistingLocalConfigurationCapability;

public class WebLogicExistingLocalConfiguration
extends AbstractExistingLocalConfiguration {
    public WebLogicExistingLocalConfiguration(File dir) {
        super(dir);
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupDeployables((Container)container, new File(this.getHome().getPath(), this.getPropertyValue("cargo.weblogic.domain")));
    }

    public ConfigurationCapability getCapability() {
        return new WebLogicExistingLocalConfigurationCapability();
    }

    public String toString() {
        return "WebLogic Existing Configuration";
    }

    protected void setupDeployables(Container container, File domainDir) {
        try {
            FileUtils fileUtils = FileUtils.newFileUtils();
            File appDir = this.getFileUtils().createDirectory(domainDir, "applications");
            Iterator it = this.getDeployables().iterator();
            while (it.hasNext()) {
                Deployable deployable = (Deployable)it.next();
                if (deployable.getType() == DeployableType.WAR && ((WAR)deployable).isExpandedWar()) continue;
                fileUtils.copyFile(deployable.getFile(), new File(appDir, deployable.getFile().getName()), null, true);
            }
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
        }
        catch (Exception e) {
            throw new ContainerException("Failed to deploy Deployables in the " + container.getName() + " [" + domainDir + "] domain directory", (Throwable)e);
        }
    }
}

